package main

import (
	"flag"
	"log"

	"code.justin.tv/video/lvsapi/streamkey"
)

var filename = flag.String("filename", "streamkey-secret.pem", "filename to which we should output the secret, any file at the destination will be overwritten")

func main() {
	log.SetFlags(0)
	flag.Parse()

	secret, err := streamkey.GenerateSecret()
	if err != nil {
		log.Fatal(err)
	}

	if err := streamkey.SaveSecret(*filename, secret); err != nil {
		log.Fatal(err)
	}

	log.Printf("Saved secret to %s", *filename)
}
