import java.security.Security;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;

public class App {

	public static void main(String[] args) {
		Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());

		Options options = new Options();

		options.addOption("servercert", true, "Optional path to server certificate for TLS mutual auth");
		options.addOption("clientcert", true, "Path to client certificate for TLS mutual auth");
		options.addOption("clientkey", true, "Path to client key for TLS mutual auth");

		String serverCert = null;
		String clientCert = null;
		String clientKey = null;

		try {
			CommandLineParser parser = new DefaultParser();
			CommandLine cmd = parser.parse(options,  args);

			serverCert = cmd.getOptionValue("servercert");
			clientCert = cmd.getOptionValue("clientcert");
			clientKey = cmd.getOptionValue("clientkey");
		} catch (Exception e) {
			System.out.println("Failed to parse command line parameters: "+e);
			System.exit(1);
		}

		System.out.println("Pulling client key from: "+clientKey);
		System.out.println("Pulling client cert from: "+clientCert);
		System.out.println("Pulling server cert from: "+serverCert);

		LvsClient client = new LvsClient(serverCert, clientCert, clientKey);

		try {
			if (!client.checkAuth()) {
				System.out.println("Authentication Failed");
			} else {
				System.out.println("Authentication Succeeded");
			}
		} catch (Exception e) {
			System.out.println("CheckAuth failed with: "+e.getMessage());
			e.printStackTrace();
			System.exit(1);
			return;
		}
	}

}
