package awsutils

import (
	"context"
	"fmt"

	"code.justin.tv/video/lvsapi/internal/constants"
	"code.justin.tv/video/lvsapi/internal/logging"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/s3/s3manager"
)

// S3RegionChecker is used to get the region a bucket is in
type S3RegionChecker struct {
}

// NewS3RegionChecker returns an S3RegionChecker to be used
func NewS3RegionChecker() *S3RegionChecker {
	return &S3RegionChecker{}
}

// GetBucketRegion queries s3 to get the region bucket was found in , returns error returned if not
func (s *S3RegionChecker) GetBucketRegion(ctx context.Context, bucket string) (string, error) {
	sess := session.Must(session.NewSession())
	// Pass us-west-2 as region hint , for the region partition to query
	awsRegion, err := s3manager.GetBucketRegion(context.Background(), sess, bucket, constants.US_WEST2_REGION)
	if err != nil {
		if awserr, ok := err.(awserr.Error); ok {
			logging.Info(ctx, "AWS bucket %s error details is : %+v  , ", bucket, awserr)
			return "", fmt.Errorf("%s %s", awserr.Code(), awserr.Message())
		}
		return "", err
	}
	logging.Info(ctx, fmt.Sprintf("bucket %s is in %s region", bucket, awsRegion))
	return awsRegion, nil
}
