package awsutils

import (
	"errors"
	"fmt"
	"strings"

	"code.justin.tv/video/lvsapi/internal/constants"
)

// ValidateSnsArn checks the given snsArn and validates it , returns error if it is not valid SNS ARN
func ValidateSnsArn(snsArn string) error {
	if snsArn == "" {
		return errors.New("SNS ARN is empty")
	}

	if !strings.HasPrefix(snsArn, constants.SNS_ARN_PREFIX) {
		return fmt.Errorf("SNS ARN %s has an invalid ARN prefix", snsArn)
	}

	snsArnData := strings.Split(snsArn, constants.ARN_SEPARATOR)
	if len(snsArnData) != 6 {
		return fmt.Errorf("SNS ARN %s has invalid format", snsArn)
	}

	if snsArnData[3] != constants.US_WEST2_REGION {
		return fmt.Errorf("SNS ARN %s has invalid region , has to be in %s ", snsArn, constants.US_WEST2_REGION)
	}

	if snsArnData[5] == "" {
		return fmt.Errorf("SNS ARN  %s has invalid topicname ", snsArn)
	}

	return nil

}
