package caching

import (
	"context"

	"code.justin.tv/video/lvsapi/internal/usher"
)

//go:generate counterfeiter ./caching.go CacheInterface

// CacheInterface defines a caching interface
type CacheInterface interface {
	GetStream(ctx context.Context, customerId, contentId string) (*usher.UsherStreamResponse, error)
	ListStreams(ctx context.Context, customerId string) ([]usher.UsherStreamResponse, error)
}
