package metrics

import (
	"time"

	"github.com/cactus/go-statsd-client/statsd"
)

const (
	maxConnectRetries = 5
	retryTimeout      = 200 * time.Millisecond
	flushInterval     = 3 * time.Second
)

// NewStatter returns a statsd client after ensuring we have
// established connection to that server
func NewStatter(serviceName, serverAddr string) (s statsd.Statter, err error) {
	for i := 0; i < maxConnectRetries; i++ {
		s, err = statsd.NewBufferedClient(serverAddr, serviceName, flushInterval, 0)
		if err == nil {
			s.SetPrefix(serviceName)
			return s, nil
		}
		time.Sleep(retryTimeout)
	}
	return nil, err
}
