package metrics

import (
	"context"
	"testing"

	"github.com/stretchr/testify/assert"

	"code.justin.tv/video/lvsapi/internal/metrics/mwsfakes"
)

func TestTwirpRequestReceivedHook(t *testing.T) {
	c := createNewTestMetricsClient()
	c.Start()

	hooks := NewTwirpMWSHooks(c)
	hooks.RequestReceived(context.Background())
	c.Stop()

	assetCommon(t)

	req, _, _ := mwsfakes.FakeMWSClientInternal.PutMetricsForAggregationArgsForCall(0)

	assert.Equal(t, "twirp.RequestReceived", req.MetricReports[0].Metrics[0].Dimensions.MethodName)
	assert.Equal(t, "NumCalls", req.MetricReports[0].Metrics[0].MetricName)
	assert.Equal(t, UnitCounter, req.MetricReports[0].Metrics[0].Unit)
	assert.Equal(t, 1.0, req.MetricReports[0].Metrics[0].Values[0])
}
