package utils

import (
	"flag"
	"os"
)

// ValidateFlags validates flags, environment variables and sets overrides
func ValidateFlags(envMap map[string]string) ([]string, error) {
	var missing []string
	for argName, envName := range envMap {
		if f := flag.Lookup(argName); f.Value.String() == f.DefValue {
			val, ok := os.LookupEnv(envName)
			if !ok || val == "" {
				if f.Value.String() == "" {
					missing = append(missing, envName)
				}
			} else {
				err := flag.Set(argName, val)
				if err != nil {
					return []string{}, err
				}
			}
		}
	}
	return missing, nil
}
