// Code generated by protoc-gen-go. DO NOT EDIT.
// source: lvs.proto

package lvs

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// This message represents a single stream in the live video system
type Stream struct {
	// Custom identifier for an individual stream(broadcast)
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Custom identifier for an individual stream(broadcast)
	ContentId string `protobuf:"bytes,2,opt,name=content_id,json=contentId,proto3" json:"content_id,omitempty"`
	// Url to use to playback video for this stream
	CdnPlaybackUrl string `protobuf:"bytes,3,opt,name=cdn_playback_url,json=cdnPlaybackUrl,proto3" json:"cdn_playback_url,omitempty"`
	// URL to use to fetch the last generated thumbnail for this stream
	CdnThumbnailUrl string `protobuf:"bytes,4,opt,name=cdn_thumbnail_url,json=cdnThumbnailUrl,proto3" json:"cdn_thumbnail_url,omitempty"`
	// RFC3339 timestamp noting when the stream started
	StartTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Same value as now()-stream_start_time truncated to second accuracy
	DurationSeconds int64 `protobuf:"varint,6,opt,name=duration_seconds,json=durationSeconds,proto3" json:"duration_seconds,omitempty"`
	// The current operational state of this stream
	Status string `protobuf:"bytes,7,opt,name=status,proto3" json:"status,omitempty"`
	// The current ingestion health of this stream
	HealthStatus string `protobuf:"bytes,8,opt,name=health_status,json=healthStatus,proto3" json:"health_status,omitempty"`
	//The reason for the current health status
	HealthReason string `protobuf:"bytes,9,opt,name=health_reason,json=healthReason,proto3" json:"health_reason,omitempty"`
	// The s3 folder in which all vods for this session are being stored
	S3VodUrl string `protobuf:"bytes,10,opt,name=s3_vod_url,json=s3VodUrl,proto3" json:"s3_vod_url,omitempty"`
	// Current viewer count as seen by the live video system viewcount service
	ViewerCount *wrappers.Int64Value `protobuf:"bytes,11,opt,name=viewer_count,json=viewerCount,proto3" json:"viewer_count,omitempty"`
	// The static VOD manifest url
	VodManifestUrl       string   `protobuf:"bytes,12,opt,name=vod_manifest_url,json=vodManifestUrl,proto3" json:"vod_manifest_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Stream) Reset()         { *m = Stream{} }
func (m *Stream) String() string { return proto.CompactTextString(m) }
func (*Stream) ProtoMessage()    {}
func (*Stream) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{0}
}

func (m *Stream) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Stream.Unmarshal(m, b)
}
func (m *Stream) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Stream.Marshal(b, m, deterministic)
}
func (m *Stream) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Stream.Merge(m, src)
}
func (m *Stream) XXX_Size() int {
	return xxx_messageInfo_Stream.Size(m)
}
func (m *Stream) XXX_DiscardUnknown() {
	xxx_messageInfo_Stream.DiscardUnknown(m)
}

var xxx_messageInfo_Stream proto.InternalMessageInfo

func (m *Stream) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *Stream) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

func (m *Stream) GetCdnPlaybackUrl() string {
	if m != nil {
		return m.CdnPlaybackUrl
	}
	return ""
}

func (m *Stream) GetCdnThumbnailUrl() string {
	if m != nil {
		return m.CdnThumbnailUrl
	}
	return ""
}

func (m *Stream) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *Stream) GetDurationSeconds() int64 {
	if m != nil {
		return m.DurationSeconds
	}
	return 0
}

func (m *Stream) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *Stream) GetHealthStatus() string {
	if m != nil {
		return m.HealthStatus
	}
	return ""
}

func (m *Stream) GetHealthReason() string {
	if m != nil {
		return m.HealthReason
	}
	return ""
}

func (m *Stream) GetS3VodUrl() string {
	if m != nil {
		return m.S3VodUrl
	}
	return ""
}

func (m *Stream) GetViewerCount() *wrappers.Int64Value {
	if m != nil {
		return m.ViewerCount
	}
	return nil
}

func (m *Stream) GetVodManifestUrl() string {
	if m != nil {
		return m.VodManifestUrl
	}
	return ""
}

type StreamKeyMetadata struct {
	//destination S3 bucket for vod storage
	S3Bucket string `protobuf:"bytes,1,opt,name=s3_bucket,json=s3Bucket,proto3" json:"s3_bucket,omitempty"`
	// SNS topic arn where stream notifications will be sent
	SnsNotificationEndpoint string `protobuf:"bytes,2,opt,name=sns_notification_endpoint,json=snsNotificationEndpoint,proto3" json:"sns_notification_endpoint,omitempty"`
	// path prefix where data will be stored in the bucket, relative to root.
	S3Prefix string `protobuf:"bytes,3,opt,name=s3_prefix,json=s3Prefix,proto3" json:"s3_prefix,omitempty"`
	// Expiration time for the particualar streamkey
	ExpirationTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	// cdn Url which will be used in the recorded static manifest
	CdnUrl string `protobuf:"bytes,5,opt,name=cdn_url,json=cdnUrl,proto3" json:"cdn_url,omitempty"`
	//Bool value which specifies if low latency transcodes are enabled
	EnableLowLatency bool `protobuf:"varint,6,opt,name=enable_low_latency,json=enableLowLatency,proto3" json:"enable_low_latency,omitempty"`
	//Latency mode specifies if we want to run in normal , low latency mode or any mode we introduce in the future
	LatencyMode          string   `protobuf:"bytes,7,opt,name=latency_mode,json=latencyMode,proto3" json:"latency_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamKeyMetadata) Reset()         { *m = StreamKeyMetadata{} }
func (m *StreamKeyMetadata) String() string { return proto.CompactTextString(m) }
func (*StreamKeyMetadata) ProtoMessage()    {}
func (*StreamKeyMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{1}
}

func (m *StreamKeyMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamKeyMetadata.Unmarshal(m, b)
}
func (m *StreamKeyMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamKeyMetadata.Marshal(b, m, deterministic)
}
func (m *StreamKeyMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamKeyMetadata.Merge(m, src)
}
func (m *StreamKeyMetadata) XXX_Size() int {
	return xxx_messageInfo_StreamKeyMetadata.Size(m)
}
func (m *StreamKeyMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamKeyMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StreamKeyMetadata proto.InternalMessageInfo

func (m *StreamKeyMetadata) GetS3Bucket() string {
	if m != nil {
		return m.S3Bucket
	}
	return ""
}

func (m *StreamKeyMetadata) GetSnsNotificationEndpoint() string {
	if m != nil {
		return m.SnsNotificationEndpoint
	}
	return ""
}

func (m *StreamKeyMetadata) GetS3Prefix() string {
	if m != nil {
		return m.S3Prefix
	}
	return ""
}

func (m *StreamKeyMetadata) GetExpirationTime() *timestamp.Timestamp {
	if m != nil {
		return m.ExpirationTime
	}
	return nil
}

func (m *StreamKeyMetadata) GetCdnUrl() string {
	if m != nil {
		return m.CdnUrl
	}
	return ""
}

func (m *StreamKeyMetadata) GetEnableLowLatency() bool {
	if m != nil {
		return m.EnableLowLatency
	}
	return false
}

func (m *StreamKeyMetadata) GetLatencyMode() string {
	if m != nil {
		return m.LatencyMode
	}
	return ""
}

// wraps information required to generate an ephemeral video stream key
type CreateStreamKeyRequest struct {
	// Custom identifier for an individual stream(broadcast)
	ContentId string `protobuf:"bytes,1,opt,name=content_id,json=contentId,proto3" json:"content_id,omitempty"`
	// destination S3 bucket for vod storage
	S3Bucket string `protobuf:"bytes,2,opt,name=s3_bucket,json=s3Bucket,proto3" json:"s3_bucket,omitempty"`
	// SNS topic arn where stream notifications will be sent
	SnsNotificationEndpoint string `protobuf:"bytes,3,opt,name=sns_notification_endpoint,json=snsNotificationEndpoint,proto3" json:"sns_notification_endpoint,omitempty"`
	// path prefix where data will be stored in the bucket, relative to root.
	S3Prefix string `protobuf:"bytes,4,opt,name=s3_prefix,json=s3Prefix,proto3" json:"s3_prefix,omitempty"`
	// time to live for this given stream key
	TtlSeconds int64 `protobuf:"varint,5,opt,name=ttl_seconds,json=ttlSeconds,proto3" json:"ttl_seconds,omitempty"`
	// cdn domain url which will be used to record static vod manifest if present
	CdnUrl string `protobuf:"bytes,6,opt,name=cdn_url,json=cdnUrl,proto3" json:"cdn_url,omitempty"`
	//boolean value to specify if want to run in low latency mode
	EnableLowLatency bool `protobuf:"varint,7,opt,name=enable_low_latency,json=enableLowLatency,proto3" json:"enable_low_latency,omitempty"`
	//Latency mode specifies if we want to run in normal , low latency mode or any mode we introduce in the future
	LatencyMode          string   `protobuf:"bytes,8,opt,name=latency_mode,json=latencyMode,proto3" json:"latency_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateStreamKeyRequest) Reset()         { *m = CreateStreamKeyRequest{} }
func (m *CreateStreamKeyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateStreamKeyRequest) ProtoMessage()    {}
func (*CreateStreamKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{2}
}

func (m *CreateStreamKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateStreamKeyRequest.Unmarshal(m, b)
}
func (m *CreateStreamKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateStreamKeyRequest.Marshal(b, m, deterministic)
}
func (m *CreateStreamKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateStreamKeyRequest.Merge(m, src)
}
func (m *CreateStreamKeyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateStreamKeyRequest.Size(m)
}
func (m *CreateStreamKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateStreamKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateStreamKeyRequest proto.InternalMessageInfo

func (m *CreateStreamKeyRequest) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

func (m *CreateStreamKeyRequest) GetS3Bucket() string {
	if m != nil {
		return m.S3Bucket
	}
	return ""
}

func (m *CreateStreamKeyRequest) GetSnsNotificationEndpoint() string {
	if m != nil {
		return m.SnsNotificationEndpoint
	}
	return ""
}

func (m *CreateStreamKeyRequest) GetS3Prefix() string {
	if m != nil {
		return m.S3Prefix
	}
	return ""
}

func (m *CreateStreamKeyRequest) GetTtlSeconds() int64 {
	if m != nil {
		return m.TtlSeconds
	}
	return 0
}

func (m *CreateStreamKeyRequest) GetCdnUrl() string {
	if m != nil {
		return m.CdnUrl
	}
	return ""
}

func (m *CreateStreamKeyRequest) GetEnableLowLatency() bool {
	if m != nil {
		return m.EnableLowLatency
	}
	return false
}

func (m *CreateStreamKeyRequest) GetLatencyMode() string {
	if m != nil {
		return m.LatencyMode
	}
	return ""
}

// Container for generated ephemeral stream key
type CreateStreamKeyResponse struct {
	// Full url to use to ingest a video session
	RtmpIngestUrl string `protobuf:"bytes,1,opt,name=rtmp_ingest_url,json=rtmpIngestUrl,proto3" json:"rtmp_ingest_url,omitempty"`
	// full url to use to playback the given content
	PlaybackUrl string `protobuf:"bytes,2,opt,name=playback_url,json=playbackUrl,proto3" json:"playback_url,omitempty"`
	// The RTMP server to send the stream to
	RtmpServer string `protobuf:"bytes,3,opt,name=rtmp_server,json=rtmpServer,proto3" json:"rtmp_server,omitempty"`
	//The streamkey to be used for sending data
	Streamkey string `protobuf:"bytes,4,opt,name=streamkey,proto3" json:"streamkey,omitempty"`
	//The Customer ID who is associated with the streamkey
	CustomerId string `protobuf:"bytes,5,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	//Custom identifier for an individual stream(broadcast)
	ContentId string `protobuf:"bytes,6,opt,name=content_id,json=contentId,proto3" json:"content_id,omitempty"`
	// The data which was sent as part of the CreateStreamKey request
	StreamkeyMetadata    *StreamKeyMetadata `protobuf:"bytes,7,opt,name=streamkey_metadata,json=streamkeyMetadata,proto3" json:"streamkey_metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *CreateStreamKeyResponse) Reset()         { *m = CreateStreamKeyResponse{} }
func (m *CreateStreamKeyResponse) String() string { return proto.CompactTextString(m) }
func (*CreateStreamKeyResponse) ProtoMessage()    {}
func (*CreateStreamKeyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{3}
}

func (m *CreateStreamKeyResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateStreamKeyResponse.Unmarshal(m, b)
}
func (m *CreateStreamKeyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateStreamKeyResponse.Marshal(b, m, deterministic)
}
func (m *CreateStreamKeyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateStreamKeyResponse.Merge(m, src)
}
func (m *CreateStreamKeyResponse) XXX_Size() int {
	return xxx_messageInfo_CreateStreamKeyResponse.Size(m)
}
func (m *CreateStreamKeyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateStreamKeyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateStreamKeyResponse proto.InternalMessageInfo

func (m *CreateStreamKeyResponse) GetRtmpIngestUrl() string {
	if m != nil {
		return m.RtmpIngestUrl
	}
	return ""
}

func (m *CreateStreamKeyResponse) GetPlaybackUrl() string {
	if m != nil {
		return m.PlaybackUrl
	}
	return ""
}

func (m *CreateStreamKeyResponse) GetRtmpServer() string {
	if m != nil {
		return m.RtmpServer
	}
	return ""
}

func (m *CreateStreamKeyResponse) GetStreamkey() string {
	if m != nil {
		return m.Streamkey
	}
	return ""
}

func (m *CreateStreamKeyResponse) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *CreateStreamKeyResponse) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

func (m *CreateStreamKeyResponse) GetStreamkeyMetadata() *StreamKeyMetadata {
	if m != nil {
		return m.StreamkeyMetadata
	}
	return nil
}

// Parameters for function call to help fetch metadata around a video stream
type GetStreamRequest struct {
	// Custom identifier for an individual stream(broadcast)
	ContentId            string   `protobuf:"bytes,1,opt,name=content_id,json=contentId,proto3" json:"content_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetStreamRequest) Reset()         { *m = GetStreamRequest{} }
func (m *GetStreamRequest) String() string { return proto.CompactTextString(m) }
func (*GetStreamRequest) ProtoMessage()    {}
func (*GetStreamRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{4}
}

func (m *GetStreamRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetStreamRequest.Unmarshal(m, b)
}
func (m *GetStreamRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetStreamRequest.Marshal(b, m, deterministic)
}
func (m *GetStreamRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetStreamRequest.Merge(m, src)
}
func (m *GetStreamRequest) XXX_Size() int {
	return xxx_messageInfo_GetStreamRequest.Size(m)
}
func (m *GetStreamRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetStreamRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetStreamRequest proto.InternalMessageInfo

func (m *GetStreamRequest) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

// Container with the information about a given stream session
type GetStreamResponse struct {
	Stream               *Stream  `protobuf:"bytes,1,opt,name=stream,proto3" json:"stream,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetStreamResponse) Reset()         { *m = GetStreamResponse{} }
func (m *GetStreamResponse) String() string { return proto.CompactTextString(m) }
func (*GetStreamResponse) ProtoMessage()    {}
func (*GetStreamResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{5}
}

func (m *GetStreamResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetStreamResponse.Unmarshal(m, b)
}
func (m *GetStreamResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetStreamResponse.Marshal(b, m, deterministic)
}
func (m *GetStreamResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetStreamResponse.Merge(m, src)
}
func (m *GetStreamResponse) XXX_Size() int {
	return xxx_messageInfo_GetStreamResponse.Size(m)
}
func (m *GetStreamResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetStreamResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetStreamResponse proto.InternalMessageInfo

func (m *GetStreamResponse) GetStream() *Stream {
	if m != nil {
		return m.Stream
	}
	return nil
}

type ListStreamsRequest struct {
	// The type of the stream( 'all' , 'live' , 'starting' ) for the given customer
	Type                 string   `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListStreamsRequest) Reset()         { *m = ListStreamsRequest{} }
func (m *ListStreamsRequest) String() string { return proto.CompactTextString(m) }
func (*ListStreamsRequest) ProtoMessage()    {}
func (*ListStreamsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{6}
}

func (m *ListStreamsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListStreamsRequest.Unmarshal(m, b)
}
func (m *ListStreamsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListStreamsRequest.Marshal(b, m, deterministic)
}
func (m *ListStreamsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListStreamsRequest.Merge(m, src)
}
func (m *ListStreamsRequest) XXX_Size() int {
	return xxx_messageInfo_ListStreamsRequest.Size(m)
}
func (m *ListStreamsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListStreamsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListStreamsRequest proto.InternalMessageInfo

func (m *ListStreamsRequest) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

type ListStreamsResponse struct {
	Streams              []*Stream `protobuf:"bytes,1,rep,name=streams,proto3" json:"streams,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *ListStreamsResponse) Reset()         { *m = ListStreamsResponse{} }
func (m *ListStreamsResponse) String() string { return proto.CompactTextString(m) }
func (*ListStreamsResponse) ProtoMessage()    {}
func (*ListStreamsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{7}
}

func (m *ListStreamsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListStreamsResponse.Unmarshal(m, b)
}
func (m *ListStreamsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListStreamsResponse.Marshal(b, m, deterministic)
}
func (m *ListStreamsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListStreamsResponse.Merge(m, src)
}
func (m *ListStreamsResponse) XXX_Size() int {
	return xxx_messageInfo_ListStreamsResponse.Size(m)
}
func (m *ListStreamsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListStreamsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListStreamsResponse proto.InternalMessageInfo

func (m *ListStreamsResponse) GetStreams() []*Stream {
	if m != nil {
		return m.Streams
	}
	return nil
}

type CheckAuthRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckAuthRequest) Reset()         { *m = CheckAuthRequest{} }
func (m *CheckAuthRequest) String() string { return proto.CompactTextString(m) }
func (*CheckAuthRequest) ProtoMessage()    {}
func (*CheckAuthRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{8}
}

func (m *CheckAuthRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckAuthRequest.Unmarshal(m, b)
}
func (m *CheckAuthRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckAuthRequest.Marshal(b, m, deterministic)
}
func (m *CheckAuthRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckAuthRequest.Merge(m, src)
}
func (m *CheckAuthRequest) XXX_Size() int {
	return xxx_messageInfo_CheckAuthRequest.Size(m)
}
func (m *CheckAuthRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckAuthRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckAuthRequest proto.InternalMessageInfo

// Response from the auth check
type CheckAuthResponse struct {
	// Custom identifier for an individual stream(broadcast)
	LvsCustomerId        string   `protobuf:"bytes,1,opt,name=lvs_customer_id,json=lvsCustomerId,proto3" json:"lvs_customer_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckAuthResponse) Reset()         { *m = CheckAuthResponse{} }
func (m *CheckAuthResponse) String() string { return proto.CompactTextString(m) }
func (*CheckAuthResponse) ProtoMessage()    {}
func (*CheckAuthResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{9}
}

func (m *CheckAuthResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckAuthResponse.Unmarshal(m, b)
}
func (m *CheckAuthResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckAuthResponse.Marshal(b, m, deterministic)
}
func (m *CheckAuthResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckAuthResponse.Merge(m, src)
}
func (m *CheckAuthResponse) XXX_Size() int {
	return xxx_messageInfo_CheckAuthResponse.Size(m)
}
func (m *CheckAuthResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckAuthResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckAuthResponse proto.InternalMessageInfo

func (m *CheckAuthResponse) GetLvsCustomerId() string {
	if m != nil {
		return m.LvsCustomerId
	}
	return ""
}

type AuthorizeBroadcastRequest struct {
	Streamkey            string   `protobuf:"bytes,1,opt,name=streamkey,proto3" json:"streamkey,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuthorizeBroadcastRequest) Reset()         { *m = AuthorizeBroadcastRequest{} }
func (m *AuthorizeBroadcastRequest) String() string { return proto.CompactTextString(m) }
func (*AuthorizeBroadcastRequest) ProtoMessage()    {}
func (*AuthorizeBroadcastRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{10}
}

func (m *AuthorizeBroadcastRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AuthorizeBroadcastRequest.Unmarshal(m, b)
}
func (m *AuthorizeBroadcastRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AuthorizeBroadcastRequest.Marshal(b, m, deterministic)
}
func (m *AuthorizeBroadcastRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuthorizeBroadcastRequest.Merge(m, src)
}
func (m *AuthorizeBroadcastRequest) XXX_Size() int {
	return xxx_messageInfo_AuthorizeBroadcastRequest.Size(m)
}
func (m *AuthorizeBroadcastRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AuthorizeBroadcastRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AuthorizeBroadcastRequest proto.InternalMessageInfo

func (m *AuthorizeBroadcastRequest) GetStreamkey() string {
	if m != nil {
		return m.Streamkey
	}
	return ""
}

type AuthorizeBroadcastResponse struct {
	// Custom identifier for an individual stream(broadcast)
	ContentId string `protobuf:"bytes,1,opt,name=content_id,json=contentId,proto3" json:"content_id,omitempty"`
	// destination S3 bucket for vod storage
	S3Bucket string `protobuf:"bytes,2,opt,name=s3_bucket,json=s3Bucket,proto3" json:"s3_bucket,omitempty"`
	// SNS topic arn where stream notifications will be sent
	SnsNotificationEndpoint string `protobuf:"bytes,3,opt,name=sns_notification_endpoint,json=snsNotificationEndpoint,proto3" json:"sns_notification_endpoint,omitempty"`
	// path prefix where data will be stored in the bucket, relative to root.
	S3Prefix string `protobuf:"bytes,4,opt,name=s3_prefix,json=s3Prefix,proto3" json:"s3_prefix,omitempty"`
	// Custom identifier for the customer
	CustomerId string `protobuf:"bytes,5,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// LVS Channel Name
	ChannelName string `protobuf:"bytes,6,opt,name=channel_name,json=channelName,proto3" json:"channel_name,omitempty"`
	// cdn url to be used for recording static VOD manifest
	CdnUrl string `protobuf:"bytes,7,opt,name=cdn_url,json=cdnUrl,proto3" json:"cdn_url,omitempty"`
	//boolean value which indicates if low latency stack is enabled
	LowLatency bool `protobuf:"varint,8,opt,name=low_latency,json=lowLatency,proto3" json:"low_latency,omitempty"`
	//The latency mode to run the specifc broadcast on
	LatencyMode          string   `protobuf:"bytes,9,opt,name=latency_mode,json=latencyMode,proto3" json:"latency_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuthorizeBroadcastResponse) Reset()         { *m = AuthorizeBroadcastResponse{} }
func (m *AuthorizeBroadcastResponse) String() string { return proto.CompactTextString(m) }
func (*AuthorizeBroadcastResponse) ProtoMessage()    {}
func (*AuthorizeBroadcastResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{11}
}

func (m *AuthorizeBroadcastResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AuthorizeBroadcastResponse.Unmarshal(m, b)
}
func (m *AuthorizeBroadcastResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AuthorizeBroadcastResponse.Marshal(b, m, deterministic)
}
func (m *AuthorizeBroadcastResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuthorizeBroadcastResponse.Merge(m, src)
}
func (m *AuthorizeBroadcastResponse) XXX_Size() int {
	return xxx_messageInfo_AuthorizeBroadcastResponse.Size(m)
}
func (m *AuthorizeBroadcastResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AuthorizeBroadcastResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AuthorizeBroadcastResponse proto.InternalMessageInfo

func (m *AuthorizeBroadcastResponse) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

func (m *AuthorizeBroadcastResponse) GetS3Bucket() string {
	if m != nil {
		return m.S3Bucket
	}
	return ""
}

func (m *AuthorizeBroadcastResponse) GetSnsNotificationEndpoint() string {
	if m != nil {
		return m.SnsNotificationEndpoint
	}
	return ""
}

func (m *AuthorizeBroadcastResponse) GetS3Prefix() string {
	if m != nil {
		return m.S3Prefix
	}
	return ""
}

func (m *AuthorizeBroadcastResponse) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *AuthorizeBroadcastResponse) GetChannelName() string {
	if m != nil {
		return m.ChannelName
	}
	return ""
}

func (m *AuthorizeBroadcastResponse) GetCdnUrl() string {
	if m != nil {
		return m.CdnUrl
	}
	return ""
}

func (m *AuthorizeBroadcastResponse) GetLowLatency() bool {
	if m != nil {
		return m.LowLatency
	}
	return false
}

func (m *AuthorizeBroadcastResponse) GetLatencyMode() string {
	if m != nil {
		return m.LatencyMode
	}
	return ""
}

type ResetStreamKeySecretRequest struct {
	CustomerId           string   `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResetStreamKeySecretRequest) Reset()         { *m = ResetStreamKeySecretRequest{} }
func (m *ResetStreamKeySecretRequest) String() string { return proto.CompactTextString(m) }
func (*ResetStreamKeySecretRequest) ProtoMessage()    {}
func (*ResetStreamKeySecretRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{12}
}

func (m *ResetStreamKeySecretRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResetStreamKeySecretRequest.Unmarshal(m, b)
}
func (m *ResetStreamKeySecretRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResetStreamKeySecretRequest.Marshal(b, m, deterministic)
}
func (m *ResetStreamKeySecretRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResetStreamKeySecretRequest.Merge(m, src)
}
func (m *ResetStreamKeySecretRequest) XXX_Size() int {
	return xxx_messageInfo_ResetStreamKeySecretRequest.Size(m)
}
func (m *ResetStreamKeySecretRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResetStreamKeySecretRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResetStreamKeySecretRequest proto.InternalMessageInfo

func (m *ResetStreamKeySecretRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

type ResetStreamKeySecretResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResetStreamKeySecretResponse) Reset()         { *m = ResetStreamKeySecretResponse{} }
func (m *ResetStreamKeySecretResponse) String() string { return proto.CompactTextString(m) }
func (*ResetStreamKeySecretResponse) ProtoMessage()    {}
func (*ResetStreamKeySecretResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{13}
}

func (m *ResetStreamKeySecretResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResetStreamKeySecretResponse.Unmarshal(m, b)
}
func (m *ResetStreamKeySecretResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResetStreamKeySecretResponse.Marshal(b, m, deterministic)
}
func (m *ResetStreamKeySecretResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResetStreamKeySecretResponse.Merge(m, src)
}
func (m *ResetStreamKeySecretResponse) XXX_Size() int {
	return xxx_messageInfo_ResetStreamKeySecretResponse.Size(m)
}
func (m *ResetStreamKeySecretResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ResetStreamKeySecretResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ResetStreamKeySecretResponse proto.InternalMessageInfo

type DecodeStreamKeyRequest struct {
	//streamkey to be decoded
	Streamkey            string   `protobuf:"bytes,1,opt,name=streamkey,proto3" json:"streamkey,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DecodeStreamKeyRequest) Reset()         { *m = DecodeStreamKeyRequest{} }
func (m *DecodeStreamKeyRequest) String() string { return proto.CompactTextString(m) }
func (*DecodeStreamKeyRequest) ProtoMessage()    {}
func (*DecodeStreamKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{14}
}

func (m *DecodeStreamKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DecodeStreamKeyRequest.Unmarshal(m, b)
}
func (m *DecodeStreamKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DecodeStreamKeyRequest.Marshal(b, m, deterministic)
}
func (m *DecodeStreamKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DecodeStreamKeyRequest.Merge(m, src)
}
func (m *DecodeStreamKeyRequest) XXX_Size() int {
	return xxx_messageInfo_DecodeStreamKeyRequest.Size(m)
}
func (m *DecodeStreamKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DecodeStreamKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DecodeStreamKeyRequest proto.InternalMessageInfo

func (m *DecodeStreamKeyRequest) GetStreamkey() string {
	if m != nil {
		return m.Streamkey
	}
	return ""
}

type DecodeStreamKeyResponse struct {
	//The customer to whom the streamkey belongs , only if decoding is succesful
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	//Custom identifier for an individual stream(broadcast)
	ContentId string `protobuf:"bytes,2,opt,name=content_id,json=contentId,proto3" json:"content_id,omitempty"`
	// The decoded streamkey metadata
	StreamkeyMetadata    *StreamKeyMetadata `protobuf:"bytes,3,opt,name=streamkey_metadata,json=streamkeyMetadata,proto3" json:"streamkey_metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *DecodeStreamKeyResponse) Reset()         { *m = DecodeStreamKeyResponse{} }
func (m *DecodeStreamKeyResponse) String() string { return proto.CompactTextString(m) }
func (*DecodeStreamKeyResponse) ProtoMessage()    {}
func (*DecodeStreamKeyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{15}
}

func (m *DecodeStreamKeyResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DecodeStreamKeyResponse.Unmarshal(m, b)
}
func (m *DecodeStreamKeyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DecodeStreamKeyResponse.Marshal(b, m, deterministic)
}
func (m *DecodeStreamKeyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DecodeStreamKeyResponse.Merge(m, src)
}
func (m *DecodeStreamKeyResponse) XXX_Size() int {
	return xxx_messageInfo_DecodeStreamKeyResponse.Size(m)
}
func (m *DecodeStreamKeyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DecodeStreamKeyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DecodeStreamKeyResponse proto.InternalMessageInfo

func (m *DecodeStreamKeyResponse) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *DecodeStreamKeyResponse) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

func (m *DecodeStreamKeyResponse) GetStreamkeyMetadata() *StreamKeyMetadata {
	if m != nil {
		return m.StreamkeyMetadata
	}
	return nil
}

type StopStreamRequest struct {
	//Custom identifier for an individual stream(broadcast)
	ContentId            string   `protobuf:"bytes,1,opt,name=content_id,json=contentId,proto3" json:"content_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopStreamRequest) Reset()         { *m = StopStreamRequest{} }
func (m *StopStreamRequest) String() string { return proto.CompactTextString(m) }
func (*StopStreamRequest) ProtoMessage()    {}
func (*StopStreamRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{16}
}

func (m *StopStreamRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopStreamRequest.Unmarshal(m, b)
}
func (m *StopStreamRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopStreamRequest.Marshal(b, m, deterministic)
}
func (m *StopStreamRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopStreamRequest.Merge(m, src)
}
func (m *StopStreamRequest) XXX_Size() int {
	return xxx_messageInfo_StopStreamRequest.Size(m)
}
func (m *StopStreamRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StopStreamRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StopStreamRequest proto.InternalMessageInfo

func (m *StopStreamRequest) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

type StopStreamResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopStreamResponse) Reset()         { *m = StopStreamResponse{} }
func (m *StopStreamResponse) String() string { return proto.CompactTextString(m) }
func (*StopStreamResponse) ProtoMessage()    {}
func (*StopStreamResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{17}
}

func (m *StopStreamResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopStreamResponse.Unmarshal(m, b)
}
func (m *StopStreamResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopStreamResponse.Marshal(b, m, deterministic)
}
func (m *StopStreamResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopStreamResponse.Merge(m, src)
}
func (m *StopStreamResponse) XXX_Size() int {
	return xxx_messageInfo_StopStreamResponse.Size(m)
}
func (m *StopStreamResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StopStreamResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StopStreamResponse proto.InternalMessageInfo

type AddLiveMetadataRequest struct {
	//Custom identifier for an individual stream(broadcast)
	ContentId            string   `protobuf:"bytes,1,opt,name=content_id,json=contentId,proto3" json:"content_id,omitempty"`
	Metadata             string   `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddLiveMetadataRequest) Reset()         { *m = AddLiveMetadataRequest{} }
func (m *AddLiveMetadataRequest) String() string { return proto.CompactTextString(m) }
func (*AddLiveMetadataRequest) ProtoMessage()    {}
func (*AddLiveMetadataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{18}
}

func (m *AddLiveMetadataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddLiveMetadataRequest.Unmarshal(m, b)
}
func (m *AddLiveMetadataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddLiveMetadataRequest.Marshal(b, m, deterministic)
}
func (m *AddLiveMetadataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddLiveMetadataRequest.Merge(m, src)
}
func (m *AddLiveMetadataRequest) XXX_Size() int {
	return xxx_messageInfo_AddLiveMetadataRequest.Size(m)
}
func (m *AddLiveMetadataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddLiveMetadataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddLiveMetadataRequest proto.InternalMessageInfo

func (m *AddLiveMetadataRequest) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

func (m *AddLiveMetadataRequest) GetMetadata() string {
	if m != nil {
		return m.Metadata
	}
	return ""
}

type AddLiveMetadataResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddLiveMetadataResponse) Reset()         { *m = AddLiveMetadataResponse{} }
func (m *AddLiveMetadataResponse) String() string { return proto.CompactTextString(m) }
func (*AddLiveMetadataResponse) ProtoMessage()    {}
func (*AddLiveMetadataResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e3d99a0b1f013c33, []int{19}
}

func (m *AddLiveMetadataResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddLiveMetadataResponse.Unmarshal(m, b)
}
func (m *AddLiveMetadataResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddLiveMetadataResponse.Marshal(b, m, deterministic)
}
func (m *AddLiveMetadataResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddLiveMetadataResponse.Merge(m, src)
}
func (m *AddLiveMetadataResponse) XXX_Size() int {
	return xxx_messageInfo_AddLiveMetadataResponse.Size(m)
}
func (m *AddLiveMetadataResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AddLiveMetadataResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AddLiveMetadataResponse proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Stream)(nil), "lvs.Stream")
	proto.RegisterType((*StreamKeyMetadata)(nil), "lvs.StreamKeyMetadata")
	proto.RegisterType((*CreateStreamKeyRequest)(nil), "lvs.CreateStreamKeyRequest")
	proto.RegisterType((*CreateStreamKeyResponse)(nil), "lvs.CreateStreamKeyResponse")
	proto.RegisterType((*GetStreamRequest)(nil), "lvs.GetStreamRequest")
	proto.RegisterType((*GetStreamResponse)(nil), "lvs.GetStreamResponse")
	proto.RegisterType((*ListStreamsRequest)(nil), "lvs.ListStreamsRequest")
	proto.RegisterType((*ListStreamsResponse)(nil), "lvs.ListStreamsResponse")
	proto.RegisterType((*CheckAuthRequest)(nil), "lvs.CheckAuthRequest")
	proto.RegisterType((*CheckAuthResponse)(nil), "lvs.CheckAuthResponse")
	proto.RegisterType((*AuthorizeBroadcastRequest)(nil), "lvs.AuthorizeBroadcastRequest")
	proto.RegisterType((*AuthorizeBroadcastResponse)(nil), "lvs.AuthorizeBroadcastResponse")
	proto.RegisterType((*ResetStreamKeySecretRequest)(nil), "lvs.ResetStreamKeySecretRequest")
	proto.RegisterType((*ResetStreamKeySecretResponse)(nil), "lvs.ResetStreamKeySecretResponse")
	proto.RegisterType((*DecodeStreamKeyRequest)(nil), "lvs.DecodeStreamKeyRequest")
	proto.RegisterType((*DecodeStreamKeyResponse)(nil), "lvs.DecodeStreamKeyResponse")
	proto.RegisterType((*StopStreamRequest)(nil), "lvs.StopStreamRequest")
	proto.RegisterType((*StopStreamResponse)(nil), "lvs.StopStreamResponse")
	proto.RegisterType((*AddLiveMetadataRequest)(nil), "lvs.AddLiveMetadataRequest")
	proto.RegisterType((*AddLiveMetadataResponse)(nil), "lvs.AddLiveMetadataResponse")
}

func init() { proto.RegisterFile("lvs.proto", fileDescriptor_e3d99a0b1f013c33) }

var fileDescriptor_e3d99a0b1f013c33 = []byte{
	// 1168 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x57, 0xcf, 0x4e, 0x23, 0xc7,
	0x13, 0x96, 0x31, 0x18, 0xbb, 0xc6, 0xbb, 0x98, 0xfe, 0xed, 0xcf, 0x36, 0x86, 0x60, 0x98, 0x55,
	0x22, 0x12, 0x45, 0xac, 0x82, 0xa3, 0x55, 0x96, 0x24, 0xab, 0x2c, 0x64, 0x15, 0xa1, 0x85, 0xd5,
	0xca, 0x5e, 0x38, 0x24, 0x87, 0x51, 0x7b, 0xa6, 0x80, 0x11, 0xe3, 0xee, 0xc9, 0x74, 0x8f, 0x59,
	0xe7, 0x69, 0x72, 0xce, 0x13, 0xe4, 0x29, 0x72, 0xc8, 0x83, 0xe4, 0x96, 0x7b, 0xd4, 0x3d, 0x3d,
	0xfe, 0x33, 0x63, 0xfe, 0x29, 0x97, 0xdc, 0x98, 0xaf, 0xaa, 0xba, 0xab, 0xbe, 0xaa, 0xaf, 0xda,
	0x40, 0x25, 0x18, 0x8a, 0xdd, 0x30, 0xe2, 0x92, 0x93, 0x62, 0x30, 0x14, 0xad, 0xf6, 0x05, 0xe7,
	0x17, 0x01, 0x3e, 0xd3, 0x50, 0x3f, 0x3e, 0x7f, 0x26, 0xfd, 0x01, 0x0a, 0x49, 0x07, 0x61, 0xe2,
	0xd5, 0xda, 0xcc, 0x3a, 0x5c, 0x47, 0x34, 0x0c, 0x31, 0x32, 0xa7, 0xd8, 0x7f, 0x15, 0xa1, 0xd4,
	0x93, 0x11, 0xd2, 0x01, 0x69, 0x83, 0xe5, 0xc6, 0x42, 0xf2, 0x01, 0x46, 0x8e, 0xef, 0x35, 0x0b,
	0x5b, 0x85, 0x9d, 0x4a, 0x17, 0x52, 0xe8, 0xc8, 0x23, 0x1f, 0x01, 0xb8, 0x9c, 0x49, 0x64, 0x52,
	0xd9, 0x17, 0xb4, 0xbd, 0x62, 0x90, 0x23, 0x8f, 0xec, 0x40, 0xcd, 0xf5, 0x98, 0x13, 0x06, 0x74,
	0xd4, 0xa7, 0xee, 0x95, 0x13, 0x47, 0x41, 0xb3, 0xa8, 0x9d, 0x1e, 0xbb, 0x1e, 0x7b, 0x67, 0xe0,
	0xd3, 0x28, 0x20, 0x9f, 0xc1, 0xaa, 0xf2, 0x94, 0x97, 0xf1, 0xa0, 0xcf, 0xa8, 0x1f, 0x68, 0xd7,
	0x45, 0xed, 0xba, 0xe2, 0x7a, 0xec, 0x7d, 0x8a, 0x2b, 0xdf, 0x17, 0x00, 0x42, 0xd2, 0x48, 0x3a,
	0xaa, 0xb2, 0xe6, 0xd2, 0x56, 0x61, 0xc7, 0xda, 0x6b, 0xed, 0x26, 0x55, 0xed, 0xa6, 0x55, 0xed,
	0xbe, 0x4f, 0xcb, 0xee, 0x56, 0xb4, 0xb7, 0xfa, 0x26, 0x9f, 0x42, 0xcd, 0x8b, 0x23, 0x2a, 0x7d,
	0xce, 0x1c, 0x81, 0x2e, 0x67, 0x9e, 0x68, 0x96, 0xb6, 0x0a, 0x3b, 0xc5, 0xee, 0x4a, 0x8a, 0xf7,
	0x12, 0x98, 0xd4, 0xa1, 0x24, 0x24, 0x95, 0xb1, 0x68, 0x2e, 0xeb, 0x34, 0xcc, 0x17, 0x79, 0x0a,
	0x8f, 0x2e, 0x91, 0x06, 0xf2, 0xd2, 0x31, 0xe6, 0xb2, 0x36, 0x57, 0x13, 0xb0, 0x97, 0x75, 0x8a,
	0x90, 0x0a, 0xce, 0x9a, 0x95, 0x69, 0xa7, 0xae, 0xc6, 0xc8, 0x06, 0x80, 0xe8, 0x38, 0x43, 0xee,
	0xe9, 0x62, 0x41, 0x7b, 0x94, 0x45, 0xe7, 0x8c, 0x7b, 0xaa, 0xca, 0x97, 0x50, 0x1d, 0xfa, 0x78,
	0x8d, 0x91, 0xe3, 0xf2, 0x98, 0xc9, 0xa6, 0xa5, 0xeb, 0x5c, 0xcf, 0xd5, 0x79, 0xc4, 0xe4, 0xf3,
	0x2f, 0xcf, 0x68, 0x10, 0x63, 0xd7, 0x4a, 0x02, 0x0e, 0x95, 0xbf, 0xe2, 0x5e, 0x1d, 0x3d, 0xa0,
	0xcc, 0x3f, 0x47, 0x21, 0xf5, 0x1d, 0xd5, 0x84, 0xfb, 0x21, 0xf7, 0x4e, 0x0c, 0x7c, 0x1a, 0x05,
	0xf6, 0xef, 0x0b, 0xb0, 0x9a, 0x34, 0xfc, 0x0d, 0x8e, 0x4e, 0x50, 0x52, 0x8f, 0x4a, 0x4a, 0xd6,
	0xa1, 0x22, 0x3a, 0x4e, 0x3f, 0x76, 0xaf, 0x50, 0x9a, 0xce, 0x97, 0x45, 0xe7, 0x40, 0x7f, 0x93,
	0x7d, 0x58, 0x13, 0x4c, 0x38, 0x8c, 0x4b, 0xff, 0xdc, 0x77, 0x13, 0x3e, 0x91, 0x79, 0x21, 0xf7,
	0x99, 0x34, 0x63, 0xd0, 0x10, 0x4c, 0xbc, 0x9d, 0xb2, 0xbf, 0x36, 0x66, 0x73, 0x70, 0x18, 0xe1,
	0xb9, 0xff, 0xc1, 0x4c, 0x43, 0x59, 0x74, 0xde, 0xe9, 0x6f, 0x72, 0x08, 0x2b, 0xf8, 0x21, 0xf4,
	0x4d, 0x8b, 0x74, 0x83, 0x17, 0xef, 0x6c, 0xf0, 0xe3, 0x49, 0x88, 0xee, 0x72, 0x03, 0x96, 0xd5,
	0x30, 0xa9, 0x8a, 0x97, 0x92, 0xde, 0xb9, 0x1e, 0x53, 0x9c, 0x7e, 0x0e, 0x04, 0x19, 0xed, 0x07,
	0xe8, 0x04, 0xfc, 0xda, 0x09, 0xa8, 0x44, 0xe6, 0x8e, 0xf4, 0x00, 0x94, 0xbb, 0xb5, 0xc4, 0x72,
	0xcc, 0xaf, 0x8f, 0x13, 0x9c, 0x6c, 0x43, 0xd5, 0xb8, 0x38, 0x03, 0xee, 0xa1, 0x99, 0x03, 0xcb,
	0x60, 0x27, 0xdc, 0x43, 0x45, 0x5d, 0xfd, 0x30, 0x42, 0x2a, 0x71, 0x4c, 0x60, 0x17, 0x7f, 0x8e,
	0x51, 0xc8, 0x8c, 0x34, 0x0a, 0x59, 0x69, 0xcc, 0xd0, 0xbb, 0xf0, 0x10, 0x7a, 0x8b, 0x0f, 0xa0,
	0x77, 0x31, 0x43, 0x6f, 0x1b, 0x2c, 0x29, 0x83, 0xf1, 0xe8, 0x2f, 0xe9, 0xd1, 0x07, 0x29, 0x83,
	0x74, 0xea, 0xa7, 0xa8, 0x2b, 0xdd, 0x83, 0xba, 0xe5, 0x7b, 0x52, 0x57, 0xce, 0x53, 0xf7, 0xdb,
	0x02, 0x34, 0x72, 0xd4, 0x89, 0x90, 0x33, 0x81, 0xe4, 0x13, 0x58, 0x89, 0xe4, 0x20, 0x74, 0x7c,
	0x76, 0x91, 0x8e, 0x6e, 0x42, 0xe0, 0x23, 0x05, 0x1f, 0x69, 0x54, 0x25, 0xb5, 0x0d, 0xd5, 0x99,
	0xdd, 0x92, 0xf0, 0x68, 0x85, 0x53, 0x8b, 0xa5, 0x0d, 0x96, 0x3e, 0x4a, 0x60, 0x34, 0xc4, 0xc8,
	0x90, 0x07, 0x0a, 0xea, 0x69, 0x84, 0x6c, 0x40, 0x45, 0xe8, 0x04, 0xae, 0x70, 0x64, 0xf8, 0x9a,
	0x00, 0xd9, 0x0d, 0xb8, 0x74, 0xc7, 0x06, 0x2c, 0x65, 0xdb, 0xfc, 0x1a, 0xc8, 0xf8, 0x30, 0x67,
	0x60, 0xb4, 0xa5, 0x69, 0xb3, 0xf6, 0xea, 0xbb, 0x6a, 0x75, 0xe7, 0x94, 0xd7, 0x5d, 0x1d, 0x47,
	0xa4, 0x90, 0xfd, 0x05, 0xd4, 0x7e, 0x40, 0x99, 0xb8, 0xde, 0x6f, 0xc0, 0xec, 0xaf, 0x60, 0x75,
	0x2a, 0xc4, 0x10, 0xfb, 0x54, 0x2d, 0x35, 0x85, 0x68, 0x7f, 0x6b, 0xcf, 0x9a, 0x4a, 0xa1, 0x6b,
	0x4c, 0xf6, 0x0e, 0x90, 0x63, 0x5f, 0x98, 0x50, 0x91, 0x5e, 0x47, 0x60, 0x51, 0x8e, 0x42, 0x34,
	0x17, 0xe9, 0xbf, 0xed, 0x6f, 0xe0, 0x7f, 0x33, 0x9e, 0xe6, 0x96, 0x8f, 0x61, 0x39, 0x39, 0x4a,
	0x34, 0x0b, 0x5b, 0xc5, 0xec, 0x35, 0xa9, 0xcd, 0x26, 0x50, 0x3b, 0xbc, 0x44, 0xf7, 0xea, 0x55,
	0xac, 0x56, 0xa2, 0xbe, 0xc5, 0xfe, 0x1a, 0x56, 0xa7, 0xb0, 0xc9, 0x38, 0x04, 0x43, 0xe1, 0xe4,
	0x9f, 0xa2, 0x47, 0xc1, 0x50, 0x1c, 0x8e, 0x7b, 0x61, 0xbf, 0x80, 0x35, 0x15, 0xc7, 0x23, 0xff,
	0x17, 0x3c, 0x88, 0x38, 0xf5, 0x5c, 0x2a, 0x64, 0x9a, 0xff, 0x4c, 0x9f, 0x0b, 0x99, 0x3e, 0xdb,
	0x7f, 0x2e, 0x40, 0x6b, 0x5e, 0xac, 0xc9, 0xe0, 0xbf, 0x2a, 0xe6, 0xdb, 0x67, 0x73, 0x1b, 0xaa,
	0xee, 0x25, 0x65, 0x0c, 0x03, 0x87, 0xd1, 0x01, 0x9a, 0xe9, 0xb4, 0x0c, 0xf6, 0x96, 0xce, 0xae,
	0xca, 0xe5, 0x19, 0xbd, 0xb7, 0xc1, 0x9a, 0x16, 0x7a, 0x59, 0x0b, 0x1d, 0x82, 0x9b, 0x25, 0x5e,
	0xc9, 0x4b, 0xfc, 0x25, 0xac, 0x77, 0x51, 0xa4, 0x43, 0xf8, 0x06, 0x47, 0x3d, 0x74, 0x23, 0x1c,
	0x77, 0xe4, 0xae, 0x5f, 0x17, 0xf6, 0x26, 0x6c, 0xcc, 0x8f, 0x4f, 0xba, 0x62, 0x3f, 0x87, 0xfa,
	0xf7, 0xe8, 0x72, 0x2f, 0xbf, 0x7c, 0x6f, 0x6f, 0xf6, 0xaf, 0x05, 0x68, 0xe4, 0x02, 0x4d, 0xa7,
	0xff, 0xed, 0x4f, 0x9e, 0xf9, 0x82, 0x2f, 0x3e, 0x54, 0xf0, 0x7b, 0xea, 0x49, 0xe6, 0xe1, 0x83,
	0x14, 0xff, 0x04, 0xc8, 0x74, 0x8c, 0x21, 0xa9, 0x07, 0xf5, 0x57, 0x9e, 0x77, 0xec, 0x0f, 0x71,
	0x7c, 0xdf, 0xfd, 0x5e, 0xa8, 0x16, 0x94, 0xc7, 0xf9, 0x9b, 0x99, 0x4e, 0xbf, 0xed, 0x35, 0x68,
	0xe4, 0x0e, 0x4d, 0xee, 0xdb, 0xfb, 0xa3, 0x00, 0x4d, 0x65, 0x38, 0xf3, 0x3d, 0xe4, 0x6a, 0xc7,
	0xfa, 0x2e, 0x1e, 0x31, 0x89, 0x11, 0xa3, 0x01, 0x39, 0x05, 0x92, 0x57, 0x19, 0xd9, 0xd4, 0xbc,
	0xdc, 0x28, 0xdd, 0x56, 0xfb, 0x46, 0xbb, 0x69, 0xda, 0x4f, 0xf0, 0x64, 0xde, 0xa0, 0x90, 0x2d,
	0x1d, 0x78, 0xcb, 0x0c, 0xb6, 0xb6, 0x6f, 0xf1, 0x30, 0x05, 0xfd, 0x5d, 0x84, 0x5a, 0xb6, 0x20,
	0xb2, 0x0f, 0x95, 0xf1, 0x9e, 0x22, 0xff, 0xd7, 0x87, 0x64, 0x77, 0x59, 0xab, 0x9e, 0x85, 0x4d,
	0xb6, 0xc7, 0xb0, 0x92, 0x79, 0xf8, 0xc8, 0x7a, 0xe2, 0x3a, 0xf7, 0x97, 0x44, 0x6b, 0x63, 0xbe,
	0xd1, 0x9c, 0xb6, 0x0f, 0x95, 0xf1, 0x9e, 0x37, 0x99, 0x64, 0x9f, 0x0a, 0x93, 0x49, 0xfe, 0x39,
	0xf8, 0x0e, 0xac, 0xa9, 0xfd, 0x4d, 0x1a, 0xda, 0x2d, 0xbf, 0xfb, 0x5b, 0xcd, 0xbc, 0x61, 0x52,
	0x4b, 0x46, 0x49, 0xa6, 0x96, 0xf9, 0xc2, 0x34, 0xb5, 0xdc, 0x24, 0xbe, 0x6f, 0x01, 0x26, 0x13,
	0x4c, 0x52, 0xb9, 0x64, 0x64, 0xd0, 0x6a, 0xe4, 0xf0, 0x49, 0x32, 0x99, 0xa9, 0x34, 0xc9, 0xcc,
	0x17, 0x80, 0x49, 0xe6, 0x86, 0x41, 0x3e, 0x58, 0xfa, 0x51, 0xfd, 0x3f, 0xd5, 0x2f, 0xe9, 0x1f,
	0x9c, 0x9d, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0x22, 0x01, 0xed, 0x9a, 0x68, 0x0d, 0x00, 0x00,
}
