// Code generated by protoc-gen-twirp v5.5.2, DO NOT EDIT.
// source: lvs.proto

/*
Package lvs is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.5.2.

It is generated from these files:
	lvs.proto
*/
package lvs

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ==================================
// LiveVideoServiceInternal Interface
// ==================================

type LiveVideoServiceInternal interface {
	// Authorizes streamkey and returns decoded streamkey on success
	AuthorizeBroadcast(context.Context, *AuthorizeBroadcastRequest) (*AuthorizeBroadcastResponse, error)

	// Resets the secret used to encrypt/decrypt stream keys for a given customer
	ResetStreamKeySecret(context.Context, *ResetStreamKeySecretRequest) (*ResetStreamKeySecretResponse, error)
}

// ========================================
// LiveVideoServiceInternal Protobuf Client
// ========================================

type liveVideoServiceInternalProtobufClient struct {
	client HTTPClient
	urls   [2]string
}

// NewLiveVideoServiceInternalProtobufClient creates a Protobuf client that implements the LiveVideoServiceInternal interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewLiveVideoServiceInternalProtobufClient(addr string, client HTTPClient) LiveVideoServiceInternal {
	prefix := urlBase(addr) + LiveVideoServiceInternalPathPrefix
	urls := [2]string{
		prefix + "AuthorizeBroadcast",
		prefix + "ResetStreamKeySecret",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &liveVideoServiceInternalProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &liveVideoServiceInternalProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *liveVideoServiceInternalProtobufClient) AuthorizeBroadcast(ctx context.Context, in *AuthorizeBroadcastRequest) (*AuthorizeBroadcastResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoServiceInternal")
	ctx = ctxsetters.WithMethodName(ctx, "AuthorizeBroadcast")
	out := new(AuthorizeBroadcastResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoServiceInternalProtobufClient) ResetStreamKeySecret(ctx context.Context, in *ResetStreamKeySecretRequest) (*ResetStreamKeySecretResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoServiceInternal")
	ctx = ctxsetters.WithMethodName(ctx, "ResetStreamKeySecret")
	out := new(ResetStreamKeySecretResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ====================================
// LiveVideoServiceInternal JSON Client
// ====================================

type liveVideoServiceInternalJSONClient struct {
	client HTTPClient
	urls   [2]string
}

// NewLiveVideoServiceInternalJSONClient creates a JSON client that implements the LiveVideoServiceInternal interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewLiveVideoServiceInternalJSONClient(addr string, client HTTPClient) LiveVideoServiceInternal {
	prefix := urlBase(addr) + LiveVideoServiceInternalPathPrefix
	urls := [2]string{
		prefix + "AuthorizeBroadcast",
		prefix + "ResetStreamKeySecret",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &liveVideoServiceInternalJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &liveVideoServiceInternalJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *liveVideoServiceInternalJSONClient) AuthorizeBroadcast(ctx context.Context, in *AuthorizeBroadcastRequest) (*AuthorizeBroadcastResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoServiceInternal")
	ctx = ctxsetters.WithMethodName(ctx, "AuthorizeBroadcast")
	out := new(AuthorizeBroadcastResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoServiceInternalJSONClient) ResetStreamKeySecret(ctx context.Context, in *ResetStreamKeySecretRequest) (*ResetStreamKeySecretResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoServiceInternal")
	ctx = ctxsetters.WithMethodName(ctx, "ResetStreamKeySecret")
	out := new(ResetStreamKeySecretResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// =======================================
// LiveVideoServiceInternal Server Handler
// =======================================

type liveVideoServiceInternalServer struct {
	LiveVideoServiceInternal
	hooks *twirp.ServerHooks
}

func NewLiveVideoServiceInternalServer(svc LiveVideoServiceInternal, hooks *twirp.ServerHooks) TwirpServer {
	return &liveVideoServiceInternalServer{
		LiveVideoServiceInternal: svc,
		hooks:                    hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *liveVideoServiceInternalServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// LiveVideoServiceInternalPathPrefix is used for all URL paths on a twirp LiveVideoServiceInternal server.
// Requests are always: POST LiveVideoServiceInternalPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const LiveVideoServiceInternalPathPrefix = "/twirp/lvs.LiveVideoServiceInternal/"

func (s *liveVideoServiceInternalServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoServiceInternal")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/lvs.LiveVideoServiceInternal/AuthorizeBroadcast":
		s.serveAuthorizeBroadcast(ctx, resp, req)
		return
	case "/twirp/lvs.LiveVideoServiceInternal/ResetStreamKeySecret":
		s.serveResetStreamKeySecret(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *liveVideoServiceInternalServer) serveAuthorizeBroadcast(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAuthorizeBroadcastJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAuthorizeBroadcastProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveVideoServiceInternalServer) serveAuthorizeBroadcastJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AuthorizeBroadcast")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AuthorizeBroadcastRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AuthorizeBroadcastResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LiveVideoServiceInternal.AuthorizeBroadcast(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AuthorizeBroadcastResponse and nil error while calling AuthorizeBroadcast. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveVideoServiceInternalServer) serveAuthorizeBroadcastProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AuthorizeBroadcast")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AuthorizeBroadcastRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AuthorizeBroadcastResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LiveVideoServiceInternal.AuthorizeBroadcast(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AuthorizeBroadcastResponse and nil error while calling AuthorizeBroadcast. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveVideoServiceInternalServer) serveResetStreamKeySecret(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveResetStreamKeySecretJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveResetStreamKeySecretProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveVideoServiceInternalServer) serveResetStreamKeySecretJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ResetStreamKeySecret")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ResetStreamKeySecretRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ResetStreamKeySecretResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LiveVideoServiceInternal.ResetStreamKeySecret(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ResetStreamKeySecretResponse and nil error while calling ResetStreamKeySecret. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveVideoServiceInternalServer) serveResetStreamKeySecretProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ResetStreamKeySecret")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ResetStreamKeySecretRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ResetStreamKeySecretResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LiveVideoServiceInternal.ResetStreamKeySecret(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ResetStreamKeySecretResponse and nil error while calling ResetStreamKeySecret. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveVideoServiceInternalServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *liveVideoServiceInternalServer) ProtocGenTwirpVersion() string {
	return "v5.5.2"
}

// ==========================
// LiveVideoService Interface
// ==========================

type LiveVideoService interface {
	CheckAuth(context.Context, *CheckAuthRequest) (*CheckAuthResponse, error)

	// Creates a signed ephemeral stream key to broadcast an LVS channel
	CreateStreamKey(context.Context, *CreateStreamKeyRequest) (*CreateStreamKeyResponse, error)

	// Retrieves information about an existing LVS ephemeral stream
	GetStream(context.Context, *GetStreamRequest) (*GetStreamResponse, error)

	// Returns a list of all streams for a given customer
	ListStreams(context.Context, *ListStreamsRequest) (*ListStreamsResponse, error)

	// Decodes a given streamkey and returns all relevant information if successful
	DecodeStreamKey(context.Context, *DecodeStreamKeyRequest) (*DecodeStreamKeyResponse, error)

	// Stop Stream can be used to disconnect rtmp and stop transcoding, viewers will not be able to view the stream
	StopStream(context.Context, *StopStreamRequest) (*StopStreamResponse, error)

	// Add metadata to a stream
	AddLiveMetadata(context.Context, *AddLiveMetadataRequest) (*AddLiveMetadataResponse, error)
}

// ================================
// LiveVideoService Protobuf Client
// ================================

type liveVideoServiceProtobufClient struct {
	client HTTPClient
	urls   [7]string
}

// NewLiveVideoServiceProtobufClient creates a Protobuf client that implements the LiveVideoService interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewLiveVideoServiceProtobufClient(addr string, client HTTPClient) LiveVideoService {
	prefix := urlBase(addr) + LiveVideoServicePathPrefix
	urls := [7]string{
		prefix + "CheckAuth",
		prefix + "CreateStreamKey",
		prefix + "GetStream",
		prefix + "ListStreams",
		prefix + "DecodeStreamKey",
		prefix + "StopStream",
		prefix + "AddLiveMetadata",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &liveVideoServiceProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &liveVideoServiceProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *liveVideoServiceProtobufClient) CheckAuth(ctx context.Context, in *CheckAuthRequest) (*CheckAuthResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoService")
	ctx = ctxsetters.WithMethodName(ctx, "CheckAuth")
	out := new(CheckAuthResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoServiceProtobufClient) CreateStreamKey(ctx context.Context, in *CreateStreamKeyRequest) (*CreateStreamKeyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoService")
	ctx = ctxsetters.WithMethodName(ctx, "CreateStreamKey")
	out := new(CreateStreamKeyResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoServiceProtobufClient) GetStream(ctx context.Context, in *GetStreamRequest) (*GetStreamResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoService")
	ctx = ctxsetters.WithMethodName(ctx, "GetStream")
	out := new(GetStreamResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoServiceProtobufClient) ListStreams(ctx context.Context, in *ListStreamsRequest) (*ListStreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoService")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreams")
	out := new(ListStreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoServiceProtobufClient) DecodeStreamKey(ctx context.Context, in *DecodeStreamKeyRequest) (*DecodeStreamKeyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoService")
	ctx = ctxsetters.WithMethodName(ctx, "DecodeStreamKey")
	out := new(DecodeStreamKeyResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoServiceProtobufClient) StopStream(ctx context.Context, in *StopStreamRequest) (*StopStreamResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoService")
	ctx = ctxsetters.WithMethodName(ctx, "StopStream")
	out := new(StopStreamResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoServiceProtobufClient) AddLiveMetadata(ctx context.Context, in *AddLiveMetadataRequest) (*AddLiveMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoService")
	ctx = ctxsetters.WithMethodName(ctx, "AddLiveMetadata")
	out := new(AddLiveMetadataResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ============================
// LiveVideoService JSON Client
// ============================

type liveVideoServiceJSONClient struct {
	client HTTPClient
	urls   [7]string
}

// NewLiveVideoServiceJSONClient creates a JSON client that implements the LiveVideoService interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewLiveVideoServiceJSONClient(addr string, client HTTPClient) LiveVideoService {
	prefix := urlBase(addr) + LiveVideoServicePathPrefix
	urls := [7]string{
		prefix + "CheckAuth",
		prefix + "CreateStreamKey",
		prefix + "GetStream",
		prefix + "ListStreams",
		prefix + "DecodeStreamKey",
		prefix + "StopStream",
		prefix + "AddLiveMetadata",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &liveVideoServiceJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &liveVideoServiceJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *liveVideoServiceJSONClient) CheckAuth(ctx context.Context, in *CheckAuthRequest) (*CheckAuthResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoService")
	ctx = ctxsetters.WithMethodName(ctx, "CheckAuth")
	out := new(CheckAuthResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoServiceJSONClient) CreateStreamKey(ctx context.Context, in *CreateStreamKeyRequest) (*CreateStreamKeyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoService")
	ctx = ctxsetters.WithMethodName(ctx, "CreateStreamKey")
	out := new(CreateStreamKeyResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoServiceJSONClient) GetStream(ctx context.Context, in *GetStreamRequest) (*GetStreamResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoService")
	ctx = ctxsetters.WithMethodName(ctx, "GetStream")
	out := new(GetStreamResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoServiceJSONClient) ListStreams(ctx context.Context, in *ListStreamsRequest) (*ListStreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoService")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreams")
	out := new(ListStreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoServiceJSONClient) DecodeStreamKey(ctx context.Context, in *DecodeStreamKeyRequest) (*DecodeStreamKeyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoService")
	ctx = ctxsetters.WithMethodName(ctx, "DecodeStreamKey")
	out := new(DecodeStreamKeyResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoServiceJSONClient) StopStream(ctx context.Context, in *StopStreamRequest) (*StopStreamResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoService")
	ctx = ctxsetters.WithMethodName(ctx, "StopStream")
	out := new(StopStreamResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoServiceJSONClient) AddLiveMetadata(ctx context.Context, in *AddLiveMetadataRequest) (*AddLiveMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoService")
	ctx = ctxsetters.WithMethodName(ctx, "AddLiveMetadata")
	out := new(AddLiveMetadataResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ===============================
// LiveVideoService Server Handler
// ===============================

type liveVideoServiceServer struct {
	LiveVideoService
	hooks *twirp.ServerHooks
}

func NewLiveVideoServiceServer(svc LiveVideoService, hooks *twirp.ServerHooks) TwirpServer {
	return &liveVideoServiceServer{
		LiveVideoService: svc,
		hooks:            hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *liveVideoServiceServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// LiveVideoServicePathPrefix is used for all URL paths on a twirp LiveVideoService server.
// Requests are always: POST LiveVideoServicePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const LiveVideoServicePathPrefix = "/twirp/lvs.LiveVideoService/"

func (s *liveVideoServiceServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "lvs")
	ctx = ctxsetters.WithServiceName(ctx, "LiveVideoService")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/lvs.LiveVideoService/CheckAuth":
		s.serveCheckAuth(ctx, resp, req)
		return
	case "/twirp/lvs.LiveVideoService/CreateStreamKey":
		s.serveCreateStreamKey(ctx, resp, req)
		return
	case "/twirp/lvs.LiveVideoService/GetStream":
		s.serveGetStream(ctx, resp, req)
		return
	case "/twirp/lvs.LiveVideoService/ListStreams":
		s.serveListStreams(ctx, resp, req)
		return
	case "/twirp/lvs.LiveVideoService/DecodeStreamKey":
		s.serveDecodeStreamKey(ctx, resp, req)
		return
	case "/twirp/lvs.LiveVideoService/StopStream":
		s.serveStopStream(ctx, resp, req)
		return
	case "/twirp/lvs.LiveVideoService/AddLiveMetadata":
		s.serveAddLiveMetadata(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *liveVideoServiceServer) serveCheckAuth(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCheckAuthJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCheckAuthProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveVideoServiceServer) serveCheckAuthJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CheckAuth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CheckAuthRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CheckAuthResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LiveVideoService.CheckAuth(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CheckAuthResponse and nil error while calling CheckAuth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveVideoServiceServer) serveCheckAuthProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CheckAuth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CheckAuthRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CheckAuthResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LiveVideoService.CheckAuth(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CheckAuthResponse and nil error while calling CheckAuth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveVideoServiceServer) serveCreateStreamKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateStreamKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateStreamKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveVideoServiceServer) serveCreateStreamKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateStreamKeyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateStreamKeyResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LiveVideoService.CreateStreamKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateStreamKeyResponse and nil error while calling CreateStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveVideoServiceServer) serveCreateStreamKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateStreamKeyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateStreamKeyResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LiveVideoService.CreateStreamKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateStreamKeyResponse and nil error while calling CreateStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveVideoServiceServer) serveGetStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveVideoServiceServer) serveGetStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetStreamRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetStreamResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LiveVideoService.GetStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetStreamResponse and nil error while calling GetStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveVideoServiceServer) serveGetStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetStreamRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetStreamResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LiveVideoService.GetStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetStreamResponse and nil error while calling GetStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveVideoServiceServer) serveListStreams(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListStreamsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListStreamsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveVideoServiceServer) serveListStreamsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListStreamsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListStreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LiveVideoService.ListStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListStreamsResponse and nil error while calling ListStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveVideoServiceServer) serveListStreamsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListStreamsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListStreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LiveVideoService.ListStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListStreamsResponse and nil error while calling ListStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveVideoServiceServer) serveDecodeStreamKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDecodeStreamKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDecodeStreamKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveVideoServiceServer) serveDecodeStreamKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DecodeStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DecodeStreamKeyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DecodeStreamKeyResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LiveVideoService.DecodeStreamKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DecodeStreamKeyResponse and nil error while calling DecodeStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveVideoServiceServer) serveDecodeStreamKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DecodeStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DecodeStreamKeyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DecodeStreamKeyResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LiveVideoService.DecodeStreamKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DecodeStreamKeyResponse and nil error while calling DecodeStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveVideoServiceServer) serveStopStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStopStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStopStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveVideoServiceServer) serveStopStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StopStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StopStreamRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StopStreamResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LiveVideoService.StopStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StopStreamResponse and nil error while calling StopStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveVideoServiceServer) serveStopStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StopStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StopStreamRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StopStreamResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LiveVideoService.StopStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StopStreamResponse and nil error while calling StopStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveVideoServiceServer) serveAddLiveMetadata(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddLiveMetadataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddLiveMetadataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveVideoServiceServer) serveAddLiveMetadataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddLiveMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddLiveMetadataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddLiveMetadataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LiveVideoService.AddLiveMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddLiveMetadataResponse and nil error while calling AddLiveMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveVideoServiceServer) serveAddLiveMetadataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddLiveMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AddLiveMetadataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddLiveMetadataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LiveVideoService.AddLiveMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddLiveMetadataResponse and nil error while calling AddLiveMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveVideoServiceServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 1
}

func (s *liveVideoServiceServer) ProtocGenTwirpVersion() string {
	return "v5.5.2"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.5.2")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1168 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x57, 0xcf, 0x4e, 0x23, 0xc7,
	0x13, 0x96, 0x31, 0x18, 0xbb, 0xc6, 0xbb, 0x98, 0xfe, 0xed, 0xcf, 0x36, 0x86, 0x60, 0x98, 0x55,
	0x22, 0x12, 0x45, 0xac, 0x82, 0xa3, 0x55, 0x96, 0x24, 0xab, 0x2c, 0x64, 0x15, 0xa1, 0x85, 0xd5,
	0xca, 0x5e, 0x38, 0x24, 0x87, 0x51, 0x7b, 0xa6, 0x80, 0x11, 0xe3, 0xee, 0xc9, 0x74, 0x8f, 0x59,
	0xe7, 0x69, 0x72, 0xce, 0x13, 0xe4, 0x29, 0x72, 0xc8, 0x83, 0xe4, 0x96, 0x7b, 0xd4, 0x3d, 0x3d,
	0xfe, 0x33, 0x63, 0xfe, 0x29, 0x97, 0xdc, 0x98, 0xaf, 0xaa, 0xba, 0xab, 0xbe, 0xaa, 0xaf, 0xda,
	0x40, 0x25, 0x18, 0x8a, 0xdd, 0x30, 0xe2, 0x92, 0x93, 0x62, 0x30, 0x14, 0xad, 0xf6, 0x05, 0xe7,
	0x17, 0x01, 0x3e, 0xd3, 0x50, 0x3f, 0x3e, 0x7f, 0x26, 0xfd, 0x01, 0x0a, 0x49, 0x07, 0x61, 0xe2,
	0xd5, 0xda, 0xcc, 0x3a, 0x5c, 0x47, 0x34, 0x0c, 0x31, 0x32, 0xa7, 0xd8, 0x7f, 0x15, 0xa1, 0xd4,
	0x93, 0x11, 0xd2, 0x01, 0x69, 0x83, 0xe5, 0xc6, 0x42, 0xf2, 0x01, 0x46, 0x8e, 0xef, 0x35, 0x0b,
	0x5b, 0x85, 0x9d, 0x4a, 0x17, 0x52, 0xe8, 0xc8, 0x23, 0x1f, 0x01, 0xb8, 0x9c, 0x49, 0x64, 0x52,
	0xd9, 0x17, 0xb4, 0xbd, 0x62, 0x90, 0x23, 0x8f, 0xec, 0x40, 0xcd, 0xf5, 0x98, 0x13, 0x06, 0x74,
	0xd4, 0xa7, 0xee, 0x95, 0x13, 0x47, 0x41, 0xb3, 0xa8, 0x9d, 0x1e, 0xbb, 0x1e, 0x7b, 0x67, 0xe0,
	0xd3, 0x28, 0x20, 0x9f, 0xc1, 0xaa, 0xf2, 0x94, 0x97, 0xf1, 0xa0, 0xcf, 0xa8, 0x1f, 0x68, 0xd7,
	0x45, 0xed, 0xba, 0xe2, 0x7a, 0xec, 0x7d, 0x8a, 0x2b, 0xdf, 0x17, 0x00, 0x42, 0xd2, 0x48, 0x3a,
	0xaa, 0xb2, 0xe6, 0xd2, 0x56, 0x61, 0xc7, 0xda, 0x6b, 0xed, 0x26, 0x55, 0xed, 0xa6, 0x55, 0xed,
	0xbe, 0x4f, 0xcb, 0xee, 0x56, 0xb4, 0xb7, 0xfa, 0x26, 0x9f, 0x42, 0xcd, 0x8b, 0x23, 0x2a, 0x7d,
	0xce, 0x1c, 0x81, 0x2e, 0x67, 0x9e, 0x68, 0x96, 0xb6, 0x0a, 0x3b, 0xc5, 0xee, 0x4a, 0x8a, 0xf7,
	0x12, 0x98, 0xd4, 0xa1, 0x24, 0x24, 0x95, 0xb1, 0x68, 0x2e, 0xeb, 0x34, 0xcc, 0x17, 0x79, 0x0a,
	0x8f, 0x2e, 0x91, 0x06, 0xf2, 0xd2, 0x31, 0xe6, 0xb2, 0x36, 0x57, 0x13, 0xb0, 0x97, 0x75, 0x8a,
	0x90, 0x0a, 0xce, 0x9a, 0x95, 0x69, 0xa7, 0xae, 0xc6, 0xc8, 0x06, 0x80, 0xe8, 0x38, 0x43, 0xee,
	0xe9, 0x62, 0x41, 0x7b, 0x94, 0x45, 0xe7, 0x8c, 0x7b, 0xaa, 0xca, 0x97, 0x50, 0x1d, 0xfa, 0x78,
	0x8d, 0x91, 0xe3, 0xf2, 0x98, 0xc9, 0xa6, 0xa5, 0xeb, 0x5c, 0xcf, 0xd5, 0x79, 0xc4, 0xe4, 0xf3,
	0x2f, 0xcf, 0x68, 0x10, 0x63, 0xd7, 0x4a, 0x02, 0x0e, 0x95, 0xbf, 0xe2, 0x5e, 0x1d, 0x3d, 0xa0,
	0xcc, 0x3f, 0x47, 0x21, 0xf5, 0x1d, 0xd5, 0x84, 0xfb, 0x21, 0xf7, 0x4e, 0x0c, 0x7c, 0x1a, 0x05,
	0xf6, 0xef, 0x0b, 0xb0, 0x9a, 0x34, 0xfc, 0x0d, 0x8e, 0x4e, 0x50, 0x52, 0x8f, 0x4a, 0x4a, 0xd6,
	0xa1, 0x22, 0x3a, 0x4e, 0x3f, 0x76, 0xaf, 0x50, 0x9a, 0xce, 0x97, 0x45, 0xe7, 0x40, 0x7f, 0x93,
	0x7d, 0x58, 0x13, 0x4c, 0x38, 0x8c, 0x4b, 0xff, 0xdc, 0x77, 0x13, 0x3e, 0x91, 0x79, 0x21, 0xf7,
	0x99, 0x34, 0x63, 0xd0, 0x10, 0x4c, 0xbc, 0x9d, 0xb2, 0xbf, 0x36, 0x66, 0x73, 0x70, 0x18, 0xe1,
	0xb9, 0xff, 0xc1, 0x4c, 0x43, 0x59, 0x74, 0xde, 0xe9, 0x6f, 0x72, 0x08, 0x2b, 0xf8, 0x21, 0xf4,
	0x4d, 0x8b, 0x74, 0x83, 0x17, 0xef, 0x6c, 0xf0, 0xe3, 0x49, 0x88, 0xee, 0x72, 0x03, 0x96, 0xd5,
	0x30, 0xa9, 0x8a, 0x97, 0x92, 0xde, 0xb9, 0x1e, 0x53, 0x9c, 0x7e, 0x0e, 0x04, 0x19, 0xed, 0x07,
	0xe8, 0x04, 0xfc, 0xda, 0x09, 0xa8, 0x44, 0xe6, 0x8e, 0xf4, 0x00, 0x94, 0xbb, 0xb5, 0xc4, 0x72,
	0xcc, 0xaf, 0x8f, 0x13, 0x9c, 0x6c, 0x43, 0xd5, 0xb8, 0x38, 0x03, 0xee, 0xa1, 0x99, 0x03, 0xcb,
	0x60, 0x27, 0xdc, 0x43, 0x45, 0x5d, 0xfd, 0x30, 0x42, 0x2a, 0x71, 0x4c, 0x60, 0x17, 0x7f, 0x8e,
	0x51, 0xc8, 0x8c, 0x34, 0x0a, 0x59, 0x69, 0xcc, 0xd0, 0xbb, 0xf0, 0x10, 0x7a, 0x8b, 0x0f, 0xa0,
	0x77, 0x31, 0x43, 0x6f, 0x1b, 0x2c, 0x29, 0x83, 0xf1, 0xe8, 0x2f, 0xe9, 0xd1, 0x07, 0x29, 0x83,
	0x74, 0xea, 0xa7, 0xa8, 0x2b, 0xdd, 0x83, 0xba, 0xe5, 0x7b, 0x52, 0x57, 0xce, 0x53, 0xf7, 0xdb,
	0x02, 0x34, 0x72, 0xd4, 0x89, 0x90, 0x33, 0x81, 0xe4, 0x13, 0x58, 0x89, 0xe4, 0x20, 0x74, 0x7c,
	0x76, 0x91, 0x8e, 0x6e, 0x42, 0xe0, 0x23, 0x05, 0x1f, 0x69, 0x54, 0x25, 0xb5, 0x0d, 0xd5, 0x99,
	0xdd, 0x92, 0xf0, 0x68, 0x85, 0x53, 0x8b, 0xa5, 0x0d, 0x96, 0x3e, 0x4a, 0x60, 0x34, 0xc4, 0xc8,
	0x90, 0x07, 0x0a, 0xea, 0x69, 0x84, 0x6c, 0x40, 0x45, 0xe8, 0x04, 0xae, 0x70, 0x64, 0xf8, 0x9a,
	0x00, 0xd9, 0x0d, 0xb8, 0x74, 0xc7, 0x06, 0x2c, 0x65, 0xdb, 0xfc, 0x1a, 0xc8, 0xf8, 0x30, 0x67,
	0x60, 0xb4, 0xa5, 0x69, 0xb3, 0xf6, 0xea, 0xbb, 0x6a, 0x75, 0xe7, 0x94, 0xd7, 0x5d, 0x1d, 0x47,
	0xa4, 0x90, 0xfd, 0x05, 0xd4, 0x7e, 0x40, 0x99, 0xb8, 0xde, 0x6f, 0xc0, 0xec, 0xaf, 0x60, 0x75,
	0x2a, 0xc4, 0x10, 0xfb, 0x54, 0x2d, 0x35, 0x85, 0x68, 0x7f, 0x6b, 0xcf, 0x9a, 0x4a, 0xa1, 0x6b,
	0x4c, 0xf6, 0x0e, 0x90, 0x63, 0x5f, 0x98, 0x50, 0x91, 0x5e, 0x47, 0x60, 0x51, 0x8e, 0x42, 0x34,
	0x17, 0xe9, 0xbf, 0xed, 0x6f, 0xe0, 0x7f, 0x33, 0x9e, 0xe6, 0x96, 0x8f, 0x61, 0x39, 0x39, 0x4a,
	0x34, 0x0b, 0x5b, 0xc5, 0xec, 0x35, 0xa9, 0xcd, 0x26, 0x50, 0x3b, 0xbc, 0x44, 0xf7, 0xea, 0x55,
	0xac, 0x56, 0xa2, 0xbe, 0xc5, 0xfe, 0x1a, 0x56, 0xa7, 0xb0, 0xc9, 0x38, 0x04, 0x43, 0xe1, 0xe4,
	0x9f, 0xa2, 0x47, 0xc1, 0x50, 0x1c, 0x8e, 0x7b, 0x61, 0xbf, 0x80, 0x35, 0x15, 0xc7, 0x23, 0xff,
	0x17, 0x3c, 0x88, 0x38, 0xf5, 0x5c, 0x2a, 0x64, 0x9a, 0xff, 0x4c, 0x9f, 0x0b, 0x99, 0x3e, 0xdb,
	0x7f, 0x2e, 0x40, 0x6b, 0x5e, 0xac, 0xc9, 0xe0, 0xbf, 0x2a, 0xe6, 0xdb, 0x67, 0x73, 0x1b, 0xaa,
	0xee, 0x25, 0x65, 0x0c, 0x03, 0x87, 0xd1, 0x01, 0x9a, 0xe9, 0xb4, 0x0c, 0xf6, 0x96, 0xce, 0xae,
	0xca, 0xe5, 0x19, 0xbd, 0xb7, 0xc1, 0x9a, 0x16, 0x7a, 0x59, 0x0b, 0x1d, 0x82, 0x9b, 0x25, 0x5e,
	0xc9, 0x4b, 0xfc, 0x25, 0xac, 0x77, 0x51, 0xa4, 0x43, 0xf8, 0x06, 0x47, 0x3d, 0x74, 0x23, 0x1c,
	0x77, 0xe4, 0xae, 0x5f, 0x17, 0xf6, 0x26, 0x6c, 0xcc, 0x8f, 0x4f, 0xba, 0x62, 0x3f, 0x87, 0xfa,
	0xf7, 0xe8, 0x72, 0x2f, 0xbf, 0x7c, 0x6f, 0x6f, 0xf6, 0xaf, 0x05, 0x68, 0xe4, 0x02, 0x4d, 0xa7,
	0xff, 0xed, 0x4f, 0x9e, 0xf9, 0x82, 0x2f, 0x3e, 0x54, 0xf0, 0x7b, 0xea, 0x49, 0xe6, 0xe1, 0x83,
	0x14, 0xff, 0x04, 0xc8, 0x74, 0x8c, 0x21, 0xa9, 0x07, 0xf5, 0x57, 0x9e, 0x77, 0xec, 0x0f, 0x71,
	0x7c, 0xdf, 0xfd, 0x5e, 0xa8, 0x16, 0x94, 0xc7, 0xf9, 0x9b, 0x99, 0x4e, 0xbf, 0xed, 0x35, 0x68,
	0xe4, 0x0e, 0x4d, 0xee, 0xdb, 0xfb, 0xa3, 0x00, 0x4d, 0x65, 0x38, 0xf3, 0x3d, 0xe4, 0x6a, 0xc7,
	0xfa, 0x2e, 0x1e, 0x31, 0x89, 0x11, 0xa3, 0x01, 0x39, 0x05, 0x92, 0x57, 0x19, 0xd9, 0xd4, 0xbc,
	0xdc, 0x28, 0xdd, 0x56, 0xfb, 0x46, 0xbb, 0x69, 0xda, 0x4f, 0xf0, 0x64, 0xde, 0xa0, 0x90, 0x2d,
	0x1d, 0x78, 0xcb, 0x0c, 0xb6, 0xb6, 0x6f, 0xf1, 0x30, 0x05, 0xfd, 0x5d, 0x84, 0x5a, 0xb6, 0x20,
	0xb2, 0x0f, 0x95, 0xf1, 0x9e, 0x22, 0xff, 0xd7, 0x87, 0x64, 0x77, 0x59, 0xab, 0x9e, 0x85, 0x4d,
	0xb6, 0xc7, 0xb0, 0x92, 0x79, 0xf8, 0xc8, 0x7a, 0xe2, 0x3a, 0xf7, 0x97, 0x44, 0x6b, 0x63, 0xbe,
	0xd1, 0x9c, 0xb6, 0x0f, 0x95, 0xf1, 0x9e, 0x37, 0x99, 0x64, 0x9f, 0x0a, 0x93, 0x49, 0xfe, 0x39,
	0xf8, 0x0e, 0xac, 0xa9, 0xfd, 0x4d, 0x1a, 0xda, 0x2d, 0xbf, 0xfb, 0x5b, 0xcd, 0xbc, 0x61, 0x52,
	0x4b, 0x46, 0x49, 0xa6, 0x96, 0xf9, 0xc2, 0x34, 0xb5, 0xdc, 0x24, 0xbe, 0x6f, 0x01, 0x26, 0x13,
	0x4c, 0x52, 0xb9, 0x64, 0x64, 0xd0, 0x6a, 0xe4, 0xf0, 0x49, 0x32, 0x99, 0xa9, 0x34, 0xc9, 0xcc,
	0x17, 0x80, 0x49, 0xe6, 0x86, 0x41, 0x3e, 0x58, 0xfa, 0x51, 0xfd, 0x3f, 0xd5, 0x2f, 0xe9, 0x1f,
	0x9c, 0x9d, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0x22, 0x01, 0xed, 0x9a, 0x68, 0x0d, 0x00, 0x00,
}
