#!/bin/bash
set -euo pipefail

# bingo build and generate coverage/test reports
export AWS_ACCESS_KEY_ID=$AWS_ACCESS_KEY_ID
export AWS_SECRET_ACCESS_KEY=$AWS_SECRET_ACCESS_KEY
# Bingo update triggers failures when running linting
# Ex. https://jenkins.internal.justin.tv/job/video-lvsapi/450/console
# bingo lint --container --root-path=/mnt/jenkins/workspace/video-lvsapi --root-import=code.justin.tv/video/lvsapi --git-sha=$GIT_COMMIT
bingo test -v --coverage=cover.out --container --git-sha=$GIT_COMMIT
bingo build --container --git-sha=$GIT_COMMIT

# push the docker container and make app.zip
TAG=docker-registry.internal.justin.tv/video/lvsapi:$(git rev-parse HEAD)
docker build -t $TAG .
docker push $TAG
cat Dockerrun.aws.json.template | sed "s#<<TAG>>#${TAG}#" > Dockerrun.aws.json
zip -r app.zip Dockerrun.aws.json .ebextensions
