#!/usr/bin/env node
import cdk = require('@aws-cdk/core');
import { TurnipStack } from '../lib/turnip-stack';

const app = new cdk.App();
new TurnipStack(app, 'turnip-stg', {
  cdkProps: {
    stackName: 'turnip-stg',
    env: {
      account: '170679240904',
      region: 'us-west-2'
    }
  },
  cidr: '172.22.0.0/22',
  turnipProps: {
    invokeFunctionRoles: [
      'arn:aws:iam::507530374281:role/drs-staging-task-role', // Discovery Rules Service Staging
      'arn:aws:iam::025746400680:role/bridge-stg-BridgeAppBridgeLambdaServiceRole033B00F-Y2CQYNURP5KB', // Video Bridge Staging
    ],
    canAccessSystemBindleLockID: 'amzn1.bindle.resource.3cpp5kumwtwgg5uie6ea',
    isAdminBindleLockID: 'amzn1.bindle.resource.3yu3ylrxy3cupiluexcq',
  },
});

new TurnipStack(app, 'turnip-prod', {
  cdkProps: {
    stackName: 'turnip-prod',
    terminationProtection: true,
    env: {
      account: '573919923217',
      region: 'us-west-2'
    }
  },
  cidr: '172.22.4.0/22',
  turnipProps: {
    invokeFunctionRoles: [
      'arn:aws:iam::590101023881:role/drs-production-task-role', // Discovery Rules Service Production
      'arn:aws:iam::000132032748:role/bridge-prod-BridgeAppBridgeLambdaServiceRole033B00-PFO2R9WHK1US', // Video Bridge Production
    ],
    canAccessSystemBindleLockID: 'amzn1.bindle.resource.46yxaaq75na2bfbgez4q',
    isAdminBindleLockID: 'amzn1.bindle.resource.fykl362ieidqxwb5adha',
  },
});
