import cdk = require('@aws-cdk/core');
import { Turnip, TurnipProps } from './turnip/turnip'
import * as ec2 from '@aws-cdk/aws-ec2';
import cm = require('./capacity-management/capacity-management');

export interface StackProps {
  cdkProps: cdk.StackProps;
  turnipProps: TurnipProps;
  cidr: string
}

export class TurnipStack extends cdk.Stack {
  Vpc: ec2.Vpc;

  constructor(scope: cdk.Construct, id: string, props: StackProps) {
    super(scope, id, props.cdkProps);

    this.Vpc = new ec2.Vpc(this, 'VPC', {
      maxAzs: 3,
      cidr: props.cidr,
    })

    // API
    new Turnip(this, 'API', this.Vpc, props.turnipProps)

    // Capacity management constructs from here https://git-aws.internal.justin.tv/coleiain/capacity-cdk but pulled in directly for now
    // Once CDK is stable I should probably add this to NPM
    new cm.CapacityCdk(this, "TwitchCapacityManagementRoles")
  }
}
