package main

import (
	"fmt"
	"net/http"
	"os"

	"code.justin.tv/amzn/TwirpGoLangAWSTransports/lambda"
	turnip "code.justin.tv/event-engineering/turnip/pkg/rpc"
	"code.justin.tv/event-engineering/turnip/pkg/svc"
	"code.justin.tv/video/brassclient"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/sirupsen/logrus"
)

func main() {
	logger := logrus.New()
	logger.SetLevel(logrus.DebugLevel)

	channelsTableName := os.Getenv("channelsTableName")
	canAccessSystemBindleLockID := os.Getenv("canAccessSystemBindleLockID")
	isAdminBindleLockID := os.Getenv("isAdminBindleLockID")

	// Create am AWS session
	sess, err := session.NewSession(&aws.Config{
		Region: aws.String(os.Getenv("AWS_REGION")),
	})

	if err != nil {
		panic(fmt.Errorf("Error creating AWS session %v", err))
	}

	ddbClient := dynamodb.New(sess)
	brassClient := brassclient.New(sess)

	// Create the Service
	turnipServer := svc.New(channelsTableName, canAccessSystemBindleLockID, isAdminBindleLockID, ddbClient, brassClient, logger)

	// Create a Twirp service based off the internal service
	err = lambda.ListenAndServe(":80", &headerMapper{
		baseHandler: turnip.NewTurnipServer(turnipServer, nil),
	})

	if err != nil {
		// TODO logging and metrics
		panic(err)
	}
}

// This will map certain http headers to context values so we can get to them inside our service
type headerMapper struct {
	baseHandler http.Handler
}

func (hm *headerMapper) ServeHTTP(w http.ResponseWriter, req *http.Request) {
	ctx := req.Context()

	userIdentifier := req.Header.Get(svc.UserIDHeader)
	ctx = svc.WithUserID(ctx, userIdentifier)

	req = req.WithContext(ctx)

	hm.baseHandler.ServeHTTP(w, req)
}
