package svc

import (
	"context"

	rpc "code.justin.tv/event-engineering/turnip/pkg/rpc"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
)

func (c *client) ListChannelIDs(ctx context.Context, req *rpc.ListChannelIDsRequest) (*rpc.ListChannelIDsResponse, error) {
	// This is the endpoint that https://git.xarth.tv/discovery/discoveryrulesservice will use consequently it has no permissions
	scanInput := &dynamodb.ScanInput{
		TableName: aws.String(c.channelsTableName),
		AttributesToGet: []*string{
			aws.String("channel_id_hash"),
			aws.String("channel_id"),
		},
	}

	if req.NextToken != "" {
		scanInput.ExclusiveStartKey = map[string]*dynamodb.AttributeValue{
			"channel_id_hash": &dynamodb.AttributeValue{
				S: aws.String(req.NextToken),
			},
		}
	}

	resp, err := c.ddb.Scan(scanInput)

	if err != nil {
		c.logger.WithError(err).Error("Failed to query dynamodb")
		return nil, err
	}

	result := &rpc.ListChannelIDsResponse{
		ChannelIds: make([]string, 0, len(resp.Items)),
	}

	if resp.LastEvaluatedKey != nil {
		result.NextToken = *resp.LastEvaluatedKey["channel_id_hash"].S
	}

	for _, ch := range resp.Items {
		result.ChannelIds = append(result.ChannelIds, *ch["channel_id"].S)
	}

	return result, nil
}
