package svc

import (
	"context"
	"fmt"

	"code.justin.tv/video/brassclient"
	"github.com/twitchtv/twirp"
)

func (c *client) hasPermission(ctx context.Context, bindleLockID string) (bool, error) {
	// This happens when testing on dev so just allow it
	if c.brass == nil {
		return true, nil
	}

	userID := UserID(ctx)
	if userID == "" {
		return false, twirp.NewError(twirp.Malformed, fmt.Sprintf("Please provide a user identifier in the header %v", UserIDHeader))
	}

	resp, err := c.brass.IsAuthorized(ctx, &brassclient.IsAuthorizedRequest{
		Operation: brassclient.OperationUnlock,
		Actor: &brassclient.ActorReference{
			Type: brassclient.ActorTypePrincipal,
			ID:   userID,
		},
		Resource: &brassclient.ResourceReference{
			Type:      brassclient.ResourceTypeLock,
			Namespace: brassclient.NamespaceBindle,
			Name:      bindleLockID,
		},
	})

	if err != nil {
		return false, fmt.Errorf("BRASS IsAuthorized user=%q %w", userID, err)
	}

	return resp.Authorized, nil
}
