package svc

import (
	"context"

	rpc "code.justin.tv/event-engineering/turnip/pkg/rpc"
	"code.justin.tv/video/brassclient"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbiface"
	"github.com/sirupsen/logrus"
)

// Client represents the RPCs for this service
type Client interface {
	AddChannel(context.Context, *rpc.AddChannelRequest) (*rpc.AddChannelResponse, error)
	GetChannel(context.Context, *rpc.GetChannelRequest) (*rpc.GetChannelResponse, error)
	UpdateChannel(ctx context.Context, req *rpc.UpdateChannelRequest) (*rpc.UpdateChannelResponse, error)
	RemoveChannel(context.Context, *rpc.RemoveChannelRequest) (*rpc.RemoveChannelResponse, error)
	ListChannels(context.Context, *rpc.ListChannelsRequest) (*rpc.ListChannelsResponse, error)
	ListChannelIDs(context.Context, *rpc.ListChannelIDsRequest) (*rpc.ListChannelIDsResponse, error)
}

type client struct {
	channelsTableName           string
	ddb                         dynamodbiface.DynamoDBAPI
	brass                       *brassclient.BRASS
	canAccessSystemBindleLockID string
	isAdminBindleLockID         string
	logger                      logrus.FieldLogger
}

// New creates the RTMP Recorder service object
func New(channelsTableName, canAccessSystemBindleLockID, isAdminBindleLockID string, ddb dynamodbiface.DynamoDBAPI, brass *brassclient.BRASS, logger logrus.FieldLogger) Client {
	return &client{
		channelsTableName:           channelsTableName,
		canAccessSystemBindleLockID: canAccessSystemBindleLockID,
		isAdminBindleLockID:         isAdminBindleLockID,
		ddb:                         ddb,
		brass:                       brass,
		logger:                      logger,
	}
}
