# EventBus Admin CLI

![Ms Frizzle](https://i.imgur.com/P6UPBLz.jpg)
> Take chances, make mistakes, get messy! - Ms. Frizzle

## Usage

The `eventbus-admin` tool needs to be run from inside the EventBus VPC. Running `./jump.sh (staging|production)` will:

1. Build `eventbus-admin` for a linux_amd64 target
2. SCP the binary to the jumpbox in `$HOME/.bin`
3. SSH to the jumpbox with `$HOME/.bin` set on the `PATH`
4. Use `eventbus-admin` and try not to break everything :)

Prefix `./jump.sh` with `SSH_USER=<ldap username>` if your LDAP username is different from your Amazon username.

## Subcommands

* `authorize-publisher` - Grants a publisher the ability to publish to an event stream, including the ability to encrypt authorized fields
* `create-subscriber-grant` - Grants a subscriber access to an authorized field
* `event-stream` - Manage EventBus event streams
* `event-type` - Manage EventBus event types
* `feature-flag` - Manage EventBus feature flags
* `help` - Help about any command
* `iam-role` - Manage EventBus IAM roles
* `list-services` - Lists registered service names and exits
* `publication` - Manage EventBus publications
* `auth-field` - Subcommands to manage EventBus authorized fields and grants (deletion & revocation, etc.)
* `version` - Prints the version and exits
