package cmd

import (
	"github.com/spf13/cobra"

	"code.justin.tv/eventbus/admin-cli/cmd/featureflag"
)

func init() {
	rootCmd.AddCommand(featureFlagCommand)

	for _, subCmd := range featureflag.Commands {
		featureFlagCommand.AddCommand(subCmd)
	}
}

var featureFlagCommand = &cobra.Command{
	Use:   "feature-flag",
	Short: "Manage EventBus feature flags",
}

func AttachFeatureFlagSubCommand(subCommand *cobra.Command) {
	featureFlagCommand.AddCommand(subCommand)
}
