package featureflag

import (
	"context"
	"log"

	"github.com/spf13/cobra"

	"code.justin.tv/eventbus/admin-cli/internal/client"
	"code.justin.tv/eventbus/admin-cli/internal/environment"
	"code.justin.tv/eventbus/admin-cli/internal/output"
	"code.justin.tv/eventbus/controlplane/rpc"
)

var featureFlagDeleteName string

func init() {
	featureFlagDeleteCommand.Flags().StringVarP(&featureFlagDeleteName, "name", "n", "", "name of feature flag")
	featureFlagDeleteCommand.MarkFlagRequired("name")
}

var featureFlagDeleteCommand = &cobra.Command{
	Use:   "delete",
	Short: "Deletes an existing feature flag",
	Run: func(cmd *cobra.Command, args []string) {
		ctx := context.Background()
		config, err := environment.Resolve()
		if err != nil {
			log.Fatal("Error resolving runtime environment: ", err.Error())
		}

		c, err := client.NewFeatureFlags(config)
		if err != nil {
			log.Fatal("Error creating feature flags client: ", err.Error())
		}

		_, err = c.Delete(ctx, &rpc.DeleteFeatureFlagsReq{
			Name: featureFlagDeleteName,
		})
		if err != nil {
			log.Fatal("Error creating feature flag: ", err.Error())
		}

		output.MapMsg("Deleted feature flag", map[string]string{
			"Name": featureFlagDeleteName,
		})
		output.Newline()
	},
}
