package featureflag

import (
	"context"
	"log"
	"strconv"

	"github.com/spf13/cobra"

	"code.justin.tv/eventbus/admin-cli/internal/client"
	"code.justin.tv/eventbus/admin-cli/internal/environment"
	"code.justin.tv/eventbus/admin-cli/internal/output"
	"code.justin.tv/eventbus/controlplane/rpc"
)

var featureFlagDisableName string

func init() {
	featureFlagDisableCommand.Flags().StringVarP(&featureFlagDisableName, "name", "n", "", "name of feature flag")
	featureFlagDisableCommand.MarkFlagRequired("name")
}

var featureFlagDisableCommand = &cobra.Command{
	Use:   "disable",
	Short: "Disables a feature flag",
	Run: func(cmd *cobra.Command, args []string) {
		ctx := context.Background()
		config, err := environment.Resolve()
		if err != nil {
			log.Fatal("Error resolving runtime environment: ", err.Error())
		}

		c, err := client.NewFeatureFlags(config)
		if err != nil {
			log.Fatal("Error creating feature flags client: ", err.Error())
		}

		_, err = c.Disable(ctx, &rpc.DisableReq{
			Name: featureFlagDisableName,
		})
		if err != nil {
			log.Fatal("Error enabling feature flag: ", err.Error())
		}

		output.MapMsg("Disabled feature flag", map[string]string{
			"Name":    featureFlagDisableName,
			"Enabled": strconv.FormatBool(false),
		})
		output.Newline()
	},
}
