package featureflag

import (
	"context"
	"log"
	"strconv"

	"github.com/spf13/cobra"

	"code.justin.tv/eventbus/admin-cli/internal/client"
	"code.justin.tv/eventbus/admin-cli/internal/environment"
	"code.justin.tv/eventbus/admin-cli/internal/output"
	"code.justin.tv/eventbus/controlplane/rpc"
)

var featureFlagEnableName string

func init() {
	featureFlagEnableCommand.Flags().StringVarP(&featureFlagEnableName, "name", "n", "", "name of feature flag")
	featureFlagEnableCommand.MarkFlagRequired("name")
}

var featureFlagEnableCommand = &cobra.Command{
	Use:   "enable",
	Short: "Enables a feature flag",
	Run: func(cmd *cobra.Command, args []string) {
		ctx := context.Background()
		config, err := environment.Resolve()
		if err != nil {
			log.Fatal("Error resolving runtime environment: ", err.Error())
		}

		c, err := client.NewFeatureFlags(config)
		if err != nil {
			log.Fatal("Error creating feature flags client: ", err.Error())
		}

		_, err = c.Enable(ctx, &rpc.EnableReq{
			Name: featureFlagEnableName,
		})
		if err != nil {
			log.Fatal("Error enabling feature flag: ", err.Error())
		}

		output.MapMsg("Enabled feature flag", map[string]string{
			"Name":    featureFlagEnableName,
			"Enabled": strconv.FormatBool(true),
		})
		output.Newline()
	},
}
