# Deprecated Event Stream Removal Instructions

Every week, the oncall should attempt to remove unnecessary deprecated events. Follow the steps below for to check for and remove all such events as needed.

1. Open the [event catalog](https://eventbus.xarth.tv/events) and check for all events with the deprecated label. You can do this by typing "deprecated" in the search field of the catalog page. If none exist, you are done.

2. For each deprecated event, follow steps 3 onward. For all of the following steps, make sure to run through them in the staging jumphost (`./jump.sh staging`) first before the production jumphost (`./jump.sh production`). Note also that for each jumphost environment, we have {dev,staging,prod} as well! Further, do not run anything in staging jumphost if the production event is not ready to be removed! Note that in staging jumphost, some of these steps may also not apply (i.e. an event's authorized fields may have no grants in staging but they might have grants in production).

3. Take a look at the [EventBus Operations Overview dashboard](https://grafana.xarth.tv/d/NdIRdTmZz/eventbus-overview?orgId=1) and find the event in question. Make sure that the event has had no messages published as well as no messages delivered in the last 14 days. If the event _does_ have publishers/subscribers within that time frame, we will not remove any records, leave that for the next oncall, you are done!

4. Open the [event catalog](https://eventbus.xarth.tv/events) and double check that the event has no subscribers attached to it (do so by expanding the event and checking the Subscribers heading under Essential Stats). The publishing service(s) responsible for deprecating the event should have reached out to the services in that list asking them to migrate off of the event. If that list is non empty you may reach out to the publisher to notify them or reach out to those subscribers and get them to disable those subscriptions. Do not remove events if there are subscribers still subscribed!

5. Notify the publishing service(s) that you are removing the event from the catalog. You can find the publishing service by opening the [event catalog](https://eventbus.xarth.tv/events) and expanding the event and checking the Publishers heading under Essential Stats.

6. If you have reached this step, you're ready to remove things! First, we will need to check if the event has associated authorized fields. You can do this by either finding the event in the [schema repo](https://git-aws.internal.justin.tv/eventbus/schema/tree/master/events) and checking for the Authorization proto tags or opening the [event catalog](https://eventbus.xarth.tv/events) and expanding the event and checking the Authorized Fields section. If the event does have authorized fields go to the next step, otherwise skip to step 8 with a message and field value of `""` and then go to step 10. The reason we must now do step 8 -> 10+ is because we made every publisher create an empty CMK grant which needs to also be removed before the event stream/type are allowed to be removed.

7. We will now revoke and remove the authorized field subscriber grants.

    Begin by listing the subscriber grants associated with the event's authorized field(s). You can find the authed field info in the [event catalog](https://eventbus.xarth.tv/events).

    ```
    $ eventbus-admin auth-field list-subscriber-grants -t DeprecatedEvent -e {development,staging,production} -m message -f field
    ```

    For each iam role in the resulting list from above, revoke and remove the grant associated with it by running the following. Note that `delete-grant` revokes and then deletes the grant.

    ```
    $ eventbus-admin auth-field delete-grant -g subscriber -e {development,staging,production} -t DeprecatedEvent -i iam_role_grant_to_be_removed -m message -f field
    ```

8. We will now revoke and remove the authorized field publisher grants. Note that `delete-grant` revokes and then deletes the grant.

    Grab the iam role of from the service that published the deprecated event from the service's edit modal in the [dashboard](https://eventbus.xarth.tv/services) before running

    ```
    $ eventbus-admin auth-field delete-grant -g publisher -e {development,staging,production} -t DeprecatedEvent -i iam_role_grant_to_be_removed -m message -f field
    ```

9. We will now remove the authorized field.

    ```
    $ eventbus-admin auth-field delete -e {development,staging,production} -t DeprecatedEvent -f field -m message
    ```

10. We will now remove the publications associated with the deprecated event. Note that we do not currently have a way to revoke publisher auth, since we are reworking the way we authorize publishing via assume roles (https://jira.twitch.com/browse/ASYNC-977). Once we have a clear story around that, we can include revocation of publisher auth in the [deletion step](https://jira.twitch.com/browse/ASYNC-976).

    First list the publications based on the event stream

    ```
    $ eventbus-admin publication list -e {development,staging,production} -t DeprecatedEvent
    ```

    Delete each of the publications to the event stream by grabbing the service id from the above list (or the dashboard).

    ```
    $ eventbus-admin publication delete -s <service_id> -e {development,staging,production} -t DeprecatedEvent
    ```

11. We can now safely remove the event streams associated with that event.

    You may list all event streams and verify the number of streams that should be deleted (it should almost always be 3, barring some weird occurrance)

    ```
    $ eventbus-admin event-stream list
    ```

    Remove the event streams with

    ```
    $ eventbus-admin event-stream delete-by-event-type -t DeprecatedEvent
    ```

    This will remove all of the associated event streams. You can run list once more to verify that those event streams are in fact gone.

12. We can now safely remove the event type itself! Open up the [staging event catalog](https://eventbus-staging.internal.justin.tv/events) or [production event catalog](https://eventbus.xarth.tv/events) to ensure that your event was indeed removed once you are done.

    ```
    $ eventbus-admin event-type delete -t DeprecatedEvent
    ```

13. Remove the event from the [schema repo](https://git-aws.internal.justin.tv/eventbus/schema) from the `events/` and `pkg/` directories. Note that you will need to admin merge the PR upon approval since there is no easy way to stop `prototool break check` from flagging those as breaking changes.
