package client

import (
	"net/http"

	s2sLog "code.justin.tv/sse/malachai/pkg/log"
	s2sCaller "code.justin.tv/sse/malachai/pkg/s2s/caller"
)

func injectS2SRoundTripper(c *http.Client, s2sName string) error {
	cfg := &s2sCaller.Config{
		DisableStatsClient: true,
	}
	t, err := s2sCaller.NewRoundTripper(s2sName, cfg, &s2sLog.NoOpLogger{})
	if err != nil {
		return err
	}
	c.Transport = t
	return nil
}
