package environment

type Environment struct {
	Environment             string
	S2SEnabled              bool
	S2SName                 string
	BaseURL                 string
	AuthorizedFieldCMK      string
	AuthorizedFieldS3Bucket string
}

var Production = &Environment{
	Environment:             "production",
	S2SEnabled:              true,
	S2SName:                 "eventbus-controlplane-admin-cli-production",
	BaseURL:                 "https://controlplane.prod.eventbus.twitch.a2z.com",
	AuthorizedFieldCMK:      "arn:aws:kms:us-west-2:859517684765:key/48c60480-9d3b-4b66-84c8-82f88e75a5ca",
	AuthorizedFieldS3Bucket: "eventbus-production-authorized-fields-cloudtrail",
}

var Staging = &Environment{
	Environment:             "staging",
	S2SEnabled:              true,
	S2SName:                 "eventbus-controlplane-admin-cli-staging",
	BaseURL:                 "https://controlplane.staging.eventbus.twitch.a2z.com",
	AuthorizedFieldCMK:      "arn:aws:kms:us-west-2:297385687169:key/5d00e4b7-4621-481a-8222-f188be05f938",
	AuthorizedFieldS3Bucket: "eventbus-staging-authorized-fields-cloudtrail",
}

var Local = &Environment{
	Environment:             "production",
	S2SEnabled:              false,
	S2SName:                 "",
	BaseURL:                 "http://localhost:8000",
	AuthorizedFieldCMK:      "arn:aws:kms:us-west-2:859517684765:key/48c60480-9d3b-4b66-84c8-82f88e75a5ca",
	AuthorizedFieldS3Bucket: "eventbus-production-authorized-fields-cloudtrail",
}
