package environment

import (
	"errors"
	"os"
)

func Resolve() (*Environment, error) {
	env := os.Getenv("ENVIRONMENT")
	switch env {
	case "staging":
		return Staging, nil
	case "local":
		return Local, nil
	case "prod", "production":
		return Production, nil
	default:
		return nil, errors.New("environment must be 'production', 'staging', or 'local'")
	}
}
