package output

import (
	"fmt"
	"os"

	"github.com/olekukonko/tablewriter"
)

func MapMsg(msg string, m map[string]string) {
	var maxKeyLen int
	for k := range m {
		if len(k) > maxKeyLen {
			maxKeyLen = len(k)
		}
	}

	fmt.Println(msg)
	fmt.Println("----------------")
	for k, v := range m {

		fmt.Printf("%*s:\t%s\n", maxKeyLen, k, v)
	}
}

func Newline() {
	fmt.Printf("\n")
}

func FatalError(err error) {
	fmt.Println("ERROR: ", err.Error())
	os.Exit(1)
}

type TableFormatter interface {
	AsTableData() [][]string
}

func Table(header []string, records TableFormatter) error {
	table := tablewriter.NewWriter(os.Stdout)
	table.SetHeader(header)

	data := records.AsTableData()
	for _, row := range data {
		table.Append(row)
	}

	table.Render()
	return nil
}
