package prompt

import (
	"fmt"
	"strings"
)

func ConfirmationCheck(msg, action, resource string, acceptableResponses []string) (bool, error) {
	fmt.Printf("Performing %s on %s, confirmation needed: %s\n>>> ", action, resource, msg)
	var response string
	_, err := fmt.Scanln(&response)
	if err != nil {
		return false, err
	}

	for _, r := range acceptableResponses {
		if strings.EqualFold(r, response) {
			return true, nil
		}
	}

	return false, nil
}
