#!/bin/bash

ACCT_ID=$1
ENVIRONMENT=$2

CREDS=$(aws sts assume-role --role-arn arn:aws:iam::${ACCT_ID}:role/jenkins-admin-cli-uploader --role-session-name s3-upload)

export AWS_ACCESS_KEY_ID=$(echo ${CREDS} | jq -r '.Credentials.AccessKeyId')
export AWS_SECRET_ACCESS_KEY=$(echo ${CREDS} | jq -r '.Credentials.SecretAccessKey')
export AWS_SESSION_TOKEN=$(echo ${CREDS} | jq -r '.Credentials.SessionToken')

aws sts get-caller-identity
aws s3 cp ./output/eventbus-admin s3://eventbus-admin-cli-${ENVIRONMENT}/bin/eventbus-admin