// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: code.justin.tv/eventbus/controlplane/rpc/event_streams.proto

/*
Package rpc is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.3.0.

It is generated from these files:
	code.justin.tv/eventbus/controlplane/rpc/event_streams.proto
	code.justin.tv/eventbus/controlplane/rpc/feature_flags.proto
	code.justin.tv/eventbus/controlplane/rpc/audit_logs.proto
	code.justin.tv/eventbus/controlplane/rpc/targets.proto
	code.justin.tv/eventbus/controlplane/rpc/services.proto
	code.justin.tv/eventbus/controlplane/rpc/subscriptions.proto
*/
package rpc

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ======================
// EventStreams Interface
// ======================

type EventStreams interface {
	// List the event streams available in the system. Does not include statistics.
	List(context.Context, *ListEventStreamsReq) (*ListEventStreamsResp, error)

	// Get details of a single event stream
	Get(context.Context, *GetEventStreamReq) (*EventStream, error)

	// Get usage statistics for a stream
	GetStats(context.Context, *GetEventStreamStatsReq) (*EventStreamStats, error)
}

// ============================
// EventStreams Protobuf Client
// ============================

type eventStreamsProtobufClient struct {
	client HTTPClient
	urls   [3]string
}

// NewEventStreamsProtobufClient creates a Protobuf client that implements the EventStreams interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewEventStreamsProtobufClient(addr string, client HTTPClient) EventStreams {
	prefix := urlBase(addr) + EventStreamsPathPrefix
	urls := [3]string{
		prefix + "List",
		prefix + "Get",
		prefix + "GetStats",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &eventStreamsProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &eventStreamsProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *eventStreamsProtobufClient) List(ctx context.Context, in *ListEventStreamsReq) (*ListEventStreamsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "EventStreams")
	ctx = ctxsetters.WithMethodName(ctx, "List")
	out := new(ListEventStreamsResp)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *eventStreamsProtobufClient) Get(ctx context.Context, in *GetEventStreamReq) (*EventStream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "EventStreams")
	ctx = ctxsetters.WithMethodName(ctx, "Get")
	out := new(EventStream)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *eventStreamsProtobufClient) GetStats(ctx context.Context, in *GetEventStreamStatsReq) (*EventStreamStats, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "EventStreams")
	ctx = ctxsetters.WithMethodName(ctx, "GetStats")
	out := new(EventStreamStats)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

// ========================
// EventStreams JSON Client
// ========================

type eventStreamsJSONClient struct {
	client HTTPClient
	urls   [3]string
}

// NewEventStreamsJSONClient creates a JSON client that implements the EventStreams interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewEventStreamsJSONClient(addr string, client HTTPClient) EventStreams {
	prefix := urlBase(addr) + EventStreamsPathPrefix
	urls := [3]string{
		prefix + "List",
		prefix + "Get",
		prefix + "GetStats",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &eventStreamsJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &eventStreamsJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *eventStreamsJSONClient) List(ctx context.Context, in *ListEventStreamsReq) (*ListEventStreamsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "EventStreams")
	ctx = ctxsetters.WithMethodName(ctx, "List")
	out := new(ListEventStreamsResp)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *eventStreamsJSONClient) Get(ctx context.Context, in *GetEventStreamReq) (*EventStream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "EventStreams")
	ctx = ctxsetters.WithMethodName(ctx, "Get")
	out := new(EventStream)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *eventStreamsJSONClient) GetStats(ctx context.Context, in *GetEventStreamStatsReq) (*EventStreamStats, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "EventStreams")
	ctx = ctxsetters.WithMethodName(ctx, "GetStats")
	out := new(EventStreamStats)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

// ===========================
// EventStreams Server Handler
// ===========================

type eventStreamsServer struct {
	EventStreams
	hooks *twirp.ServerHooks
}

func NewEventStreamsServer(svc EventStreams, hooks *twirp.ServerHooks) TwirpServer {
	return &eventStreamsServer{
		EventStreams: svc,
		hooks:        hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *eventStreamsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// EventStreamsPathPrefix is used for all URL paths on a twirp EventStreams server.
// Requests are always: POST EventStreamsPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const EventStreamsPathPrefix = "/twirp/code.justin.tv.eventbus.controlplane.EventStreams/"

func (s *eventStreamsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "EventStreams")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.eventbus.controlplane.EventStreams/List":
		s.serveList(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.EventStreams/Get":
		s.serveGet(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.EventStreams/GetStats":
		s.serveGetStats(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *eventStreamsServer) serveList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *eventStreamsServer) serveListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "List")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListEventStreamsReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListEventStreamsResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.List(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEventStreamsResp and nil error while calling List. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *eventStreamsServer) serveListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "List")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListEventStreamsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListEventStreamsResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.List(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEventStreamsResp and nil error while calling List. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *eventStreamsServer) serveGet(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *eventStreamsServer) serveGetJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Get")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetEventStreamReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EventStream
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Get(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EventStream and nil error while calling Get. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *eventStreamsServer) serveGetProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Get")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetEventStreamReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EventStream
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Get(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EventStream and nil error while calling Get. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *eventStreamsServer) serveGetStats(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStatsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStatsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *eventStreamsServer) serveGetStatsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStats")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetEventStreamStatsReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EventStreamStats
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetStats(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EventStreamStats and nil error while calling GetStats. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *eventStreamsServer) serveGetStatsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStats")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetEventStreamStatsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EventStreamStats
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetStats(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EventStreamStats and nil error while calling GetStats. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *eventStreamsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *eventStreamsServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// ====================
// EventTypes Interface
// ====================

type EventTypes interface {
	// List the event types available in the system.
	List(context.Context, *ListEventTypesReq) (*ListEventTypesResp, error)
}

// ==========================
// EventTypes Protobuf Client
// ==========================

type eventTypesProtobufClient struct {
	client HTTPClient
	urls   [1]string
}

// NewEventTypesProtobufClient creates a Protobuf client that implements the EventTypes interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewEventTypesProtobufClient(addr string, client HTTPClient) EventTypes {
	prefix := urlBase(addr) + EventTypesPathPrefix
	urls := [1]string{
		prefix + "List",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &eventTypesProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &eventTypesProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *eventTypesProtobufClient) List(ctx context.Context, in *ListEventTypesReq) (*ListEventTypesResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "EventTypes")
	ctx = ctxsetters.WithMethodName(ctx, "List")
	out := new(ListEventTypesResp)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

// ======================
// EventTypes JSON Client
// ======================

type eventTypesJSONClient struct {
	client HTTPClient
	urls   [1]string
}

// NewEventTypesJSONClient creates a JSON client that implements the EventTypes interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewEventTypesJSONClient(addr string, client HTTPClient) EventTypes {
	prefix := urlBase(addr) + EventTypesPathPrefix
	urls := [1]string{
		prefix + "List",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &eventTypesJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &eventTypesJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *eventTypesJSONClient) List(ctx context.Context, in *ListEventTypesReq) (*ListEventTypesResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "EventTypes")
	ctx = ctxsetters.WithMethodName(ctx, "List")
	out := new(ListEventTypesResp)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

// =========================
// EventTypes Server Handler
// =========================

type eventTypesServer struct {
	EventTypes
	hooks *twirp.ServerHooks
}

func NewEventTypesServer(svc EventTypes, hooks *twirp.ServerHooks) TwirpServer {
	return &eventTypesServer{
		EventTypes: svc,
		hooks:      hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *eventTypesServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// EventTypesPathPrefix is used for all URL paths on a twirp EventTypes server.
// Requests are always: POST EventTypesPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const EventTypesPathPrefix = "/twirp/code.justin.tv.eventbus.controlplane.EventTypes/"

func (s *eventTypesServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "EventTypes")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.eventbus.controlplane.EventTypes/List":
		s.serveList(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *eventTypesServer) serveList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *eventTypesServer) serveListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "List")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListEventTypesReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListEventTypesResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.List(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEventTypesResp and nil error while calling List. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *eventTypesServer) serveListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "List")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListEventTypesReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListEventTypesResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.List(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEventTypesResp and nil error while calling List. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *eventTypesServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 1
}

func (s *eventTypesServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.3.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 974 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xcf, 0x6f, 0x1b, 0x45,
	0x14, 0xd6, 0xe6, 0x57, 0xe3, 0x67, 0xa7, 0x49, 0x26, 0x21, 0xac, 0x2c, 0x0a, 0xc1, 0x70, 0x88,
	0x84, 0xba, 0x16, 0x46, 0xa5, 0xa4, 0x2d, 0x07, 0x9a, 0xd2, 0x08, 0xa9, 0x85, 0x60, 0x87, 0x4a,
	0xe4, 0xb2, 0x1a, 0xef, 0xbe, 0xd8, 0x83, 0x76, 0x77, 0xa6, 0x33, 0xb3, 0x21, 0x8e, 0x84, 0x84,
	0xc4, 0x81, 0x1b, 0xfc, 0x25, 0x1c, 0xf9, 0xff, 0xd0, 0xcc, 0xac, 0xd7, 0x1b, 0xdb, 0x52, 0x9c,
	0xd0, 0xdb, 0xee, 0x7b, 0xef, 0xfb, 0xf6, 0xcd, 0x9b, 0xef, 0x9b, 0x59, 0x78, 0x16, 0xf1, 0x18,
	0x83, 0x5f, 0x72, 0xa5, 0x59, 0x16, 0xe8, 0x8b, 0x36, 0x5e, 0x60, 0xa6, 0xfb, 0xb9, 0x6a, 0x47,
	0x3c, 0xd3, 0x92, 0x27, 0x22, 0xa1, 0x19, 0xb6, 0xa5, 0x88, 0x5c, 0x26, 0x54, 0x5a, 0x22, 0x4d,
	0x55, 0x20, 0x24, 0xd7, 0x9c, 0x7c, 0x7a, 0x1d, 0x1d, 0x8c, 0xd1, 0x41, 0x15, 0xdd, 0x7c, 0x3a,
	0x60, 0x7a, 0x98, 0xf7, 0x83, 0x88, 0xa7, 0xed, 0x01, 0x4f, 0x68, 0x36, 0x68, 0x5b, 0x78, 0x3f,
	0x3f, 0x6f, 0x0b, 0x3d, 0x12, 0xa8, 0xda, 0x9a, 0xa5, 0xa8, 0x34, 0x4d, 0xc5, 0xe4, 0xc9, 0x7d,
	0xa2, 0x79, 0x78, 0x33, 0xf8, 0x57, 0x49, 0x85, 0x40, 0x39, 0x79, 0x70, 0xd0, 0xd6, 0xbf, 0x1e,
	0xd4, 0xbe, 0x35, 0x1d, 0x9d, 0x8e, 0x04, 0x92, 0xfb, 0xb0, 0xc4, 0x62, 0xdf, 0xdb, 0xf7, 0x0e,
	0x6a, 0xdd, 0x25, 0x16, 0x13, 0x02, 0x2b, 0x19, 0x4d, 0xd1, 0x5f, 0xb2, 0x11, 0xfb, 0x4c, 0xf6,
	0xa1, 0x1e, 0xa3, 0x8a, 0x24, 0x13, 0x9a, 0xf1, 0xcc, 0x5f, 0xb6, 0xa9, 0x6a, 0x88, 0x7c, 0x02,
	0x1b, 0x12, 0x05, 0x0f, 0xcf, 0x59, 0x82, 0x82, 0xea, 0xa1, 0xbf, 0x62, 0x6b, 0x1a, 0x26, 0xf8,
	0xb2, 0x88, 0x91, 0x0f, 0x01, 0x62, 0x14, 0x12, 0x23, 0xaa, 0x31, 0xf6, 0x57, 0xf7, 0xbd, 0x83,
	0xf5, 0x6e, 0x25, 0x42, 0x1e, 0x00, 0x24, 0x31, 0x15, 0xe1, 0x40, 0xf2, 0x5c, 0xf8, 0x6b, 0x96,
	0xa1, 0x66, 0x22, 0xc7, 0x26, 0xd0, 0xea, 0xc0, 0xf6, 0x2b, 0xa6, 0x74, 0xd9, 0xba, 0xea, 0xe2,
	0xdb, 0x29, 0x8c, 0x37, 0x8d, 0x39, 0x07, 0x32, 0x8d, 0x51, 0x82, 0x9c, 0x40, 0xdd, 0x6d, 0x9b,
	0x1d, 0x94, 0xef, 0xed, 0x2f, 0x1f, 0xd4, 0x3b, 0xed, 0x60, 0x91, 0x5d, 0x0b, 0x4a, 0xaa, 0x2e,
	0x60, 0xc9, 0xda, 0x7a, 0x08, 0x3b, 0xe5, 0x77, 0x7a, 0x4e, 0x0b, 0xa6, 0xbb, 0x3d, 0x58, 0x8b,
	0x72, 0xa9, 0xb8, 0x2c, 0x3a, 0x2b, 0xde, 0x5a, 0x7f, 0x7b, 0xb0, 0x3b, 0x5b, 0xaf, 0x04, 0x79,
	0x03, 0x1b, 0xd7, 0x04, 0x55, 0xf4, 0xf6, 0xf9, 0x2d, 0x7a, 0x73, 0x74, 0xdd, 0x06, 0x56, 0xb8,
	0xc9, 0x47, 0x50, 0xcf, 0xf0, 0x52, 0x87, 0x45, 0x37, 0x6e, 0x73, 0xc1, 0x84, 0x8e, 0x5c, 0x47,
	0xa7, 0xb0, 0x7d, 0x8c, 0xd5, 0x7e, 0x8a, 0xe1, 0x4e, 0xe6, 0x34, 0x1e, 0x6e, 0xb9, 0x6a, 0x23,
	0x0b, 0xcc, 0x2e, 0x98, 0xe4, 0x59, 0x8a, 0x99, 0x2e, 0x48, 0xab, 0xa1, 0xd6, 0xcf, 0xb0, 0x77,
	0x9d, 0xb5, 0xa7, 0xa9, 0x56, 0xef, 0x84, 0xfa, 0x9f, 0x15, 0xa8, 0x57, 0x88, 0xff, 0x37, 0x21,
	0xf9, 0x18, 0x1a, 0x31, 0x53, 0x22, 0xa1, 0xa3, 0xd0, 0x1a, 0x60, 0xac, 0x72, 0x17, 0xfb, 0xde,
	0xf8, 0xe0, 0x33, 0xd8, 0x56, 0x43, 0x2e, 0x75, 0x58, 0x75, 0x83, 0x53, 0xfa, 0x96, 0x4d, 0xbc,
	0xa8, 0x58, 0xe2, 0x6b, 0x68, 0xd0, 0x48, 0xb3, 0x0b, 0x0c, 0x15, 0xcb, 0x22, 0xb4, 0x7a, 0xaf,
	0x77, 0x9a, 0xc1, 0x80, 0xf3, 0x41, 0x82, 0xc1, 0xd8, 0xad, 0xc1, 0xe9, 0xd8, 0xd9, 0xdd, 0xba,
	0xab, 0xef, 0x99, 0xf2, 0x69, 0xcf, 0xad, 0xcd, 0x7a, 0xee, 0x15, 0xac, 0x2a, 0x33, 0x4e, 0xff,
	0x9e, 0x65, 0xfe, 0xf2, 0xd6, 0x1a, 0x71, 0x9b, 0xe1, 0x48, 0x8c, 0x54, 0x55, 0x34, 0xc4, 0x94,
	0xfa, 0xeb, 0x4e, 0xaa, 0xee, 0x6d, 0xd6, 0xd9, 0xb5, 0x39, 0xce, 0xee, 0xc3, 0x36, 0xcd, 0xf5,
	0x90, 0x4b, 0x76, 0x85, 0x71, 0x78, 0xce, 0x30, 0x89, 0x95, 0x0f, 0x56, 0xba, 0x8f, 0x16, 0x6b,
	0xeb, 0x9b, 0x12, 0xfe, 0xd2, 0xa0, 0xbb, 0x5b, 0xf4, 0x7a, 0x40, 0x4d, 0x9d, 0x1e, 0xf5, 0x1b,
	0x4e, 0x8f, 0xc6, 0xf4, 0x49, 0xf0, 0xd7, 0x2a, 0x6c, 0x4d, 0xaf, 0x9d, 0x3c, 0x85, 0x75, 0x2d,
	0x54, 0x98, 0x22, 0xcd, 0xac, 0x64, 0xea, 0x9d, 0x0f, 0x66, 0xf6, 0xe7, 0x05, 0xcf, 0xfb, 0x09,
	0xbe, 0xa1, 0x49, 0x8e, 0xcf, 0x97, 0x7c, 0xaf, 0x7b, 0x4f, 0x0b, 0xf5, 0x1a, 0x69, 0x36, 0x06,
	0x1f, 0x3e, 0xd2, 0x43, 0xab, 0xa7, 0x45, 0xc1, 0x06, 0x40, 0x7e, 0x84, 0x3d, 0xf3, 0xd5, 0xd0,
	0x4e, 0x43, 0x85, 0x02, 0x65, 0x98, 0xb2, 0x2c, 0xd7, 0x4e, 0x77, 0x37, 0x50, 0x75, 0x77, 0x0c,
	0xd6, 0xae, 0x46, 0x9d, 0xa0, 0x7c, 0x6d, 0x81, 0xe4, 0x07, 0x78, 0x2f, 0xa5, 0x97, 0x73, 0x18,
	0x57, 0x16, 0x60, 0x24, 0x29, 0xbd, 0x9c, 0x47, 0xc8, 0xe6, 0xb5, 0xb8, 0xba, 0x10, 0x21, 0x9b,
	0xe9, 0xb0, 0x07, 0xef, 0x4f, 0x16, 0x1d, 0x0a, 0x3a, 0x4a, 0x38, 0x8d, 0x43, 0xc5, 0xae, 0xd0,
	0xea, 0xfb, 0x26, 0xca, 0xdd, 0x72, 0xd5, 0x27, 0x0e, 0xda, 0x63, 0x57, 0xc6, 0x94, 0x9b, 0x22,
	0xef, 0x27, 0x4c, 0x0d, 0x51, 0x86, 0x11, 0xcf, 0x33, 0x6d, 0x0d, 0xb1, 0x61, 0xe7, 0x7d, 0xbf,
	0x4c, 0x1d, 0x99, 0x0c, 0x79, 0x08, 0x5b, 0x2a, 0xef, 0x1b, 0x0f, 0xf5, 0xcb, 0xea, 0xf5, 0xb2,
	0x7a, 0x73, 0x92, 0x73, 0xe5, 0x67, 0x00, 0x25, 0x81, 0xf2, 0x6b, 0x56, 0xd0, 0x4f, 0x16, 0x13,
	0xf4, 0xc9, 0x18, 0xd7, 0x43, 0x79, 0xc1, 0x22, 0xfc, 0x2e, 0x3b, 0xe7, 0xdd, 0x0a, 0x5b, 0xeb,
	0x0c, 0x76, 0xe7, 0xd5, 0x94, 0x17, 0xb0, 0x57, 0xb9, 0x80, 0x03, 0xd8, 0x51, 0xae, 0x24, 0x8c,
	0xa8, 0xa6, 0x09, 0x1f, 0x84, 0xb9, 0x4c, 0x8a, 0x53, 0x6c, 0xbb, 0x48, 0x1d, 0xb9, 0xcc, 0x4f,
	0x32, 0x69, 0xf5, 0x60, 0x73, 0xca, 0x50, 0xe6, 0x78, 0x4b, 0x51, 0x29, 0x3a, 0xc0, 0xb0, 0x42,
	0x5f, 0x2f, 0x62, 0xf6, 0x78, 0x7b, 0x00, 0x60, 0xad, 0x1b, 0x56, 0x7e, 0x00, 0x6a, 0x36, 0x62,
	0xd2, 0x9d, 0x3f, 0x96, 0xa1, 0x51, 0xbd, 0xb0, 0xc8, 0x6f, 0xb0, 0x62, 0x2e, 0x31, 0x72, 0xb8,
	0xd8, 0x44, 0xe6, 0x5c, 0x90, 0xcd, 0x27, 0x77, 0x85, 0x2a, 0x41, 0xde, 0xc2, 0xf2, 0x31, 0x6a,
	0xf2, 0x78, 0x31, 0x8a, 0x99, 0xdb, 0xad, 0x79, 0xfb, 0x4b, 0x95, 0xfc, 0xee, 0xc1, 0xfa, 0x31,
	0x6a, 0x77, 0x78, 0x3c, 0xbb, 0xcb, 0x87, 0xc7, 0x17, 0x60, 0xf3, 0x8e, 0xc7, 0x75, 0xe7, 0x4f,
	0x0f, 0x60, 0xf2, 0x3b, 0x43, 0x46, 0xc5, 0x1e, 0x3c, 0xbe, 0xe5, 0x20, 0xc7, 0x3f, 0x50, 0xcd,
	0xaf, 0xee, 0x06, 0x54, 0xe2, 0xf9, 0xea, 0xd9, 0xb2, 0x14, 0x51, 0x7f, 0xcd, 0x7a, 0xf5, 0x8b,
	0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0x3f, 0x5f, 0x1b, 0xa0, 0x33, 0x0b, 0x00, 0x00,
}
