// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: code.justin.tv/eventbus/controlplane/rpc/feature_flags.proto

package rpc

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// ======================
// FeatureFlags Interface
// ======================

type FeatureFlags interface {
	IsEnabled(context.Context, *IsEnabledReq) (*IsEnabledResp, error)

	Enable(context.Context, *EnableReq) (*EnableResp, error)

	Disable(context.Context, *DisableReq) (*DisableResp, error)

	List(context.Context, *ListFeatureFlagsReq) (*ListFeatureFlagsResp, error)

	Create(context.Context, *CreateFeatureFlagsReq) (*CreateFeatureFlagsResp, error)

	Delete(context.Context, *DeleteFeatureFlagsReq) (*DeleteFeatureFlagsResp, error)
}

// ============================
// FeatureFlags Protobuf Client
// ============================

type featureFlagsProtobufClient struct {
	client HTTPClient
	urls   [6]string
}

// NewFeatureFlagsProtobufClient creates a Protobuf client that implements the FeatureFlags interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewFeatureFlagsProtobufClient(addr string, client HTTPClient) FeatureFlags {
	prefix := urlBase(addr) + FeatureFlagsPathPrefix
	urls := [6]string{
		prefix + "IsEnabled",
		prefix + "Enable",
		prefix + "Disable",
		prefix + "List",
		prefix + "Create",
		prefix + "Delete",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &featureFlagsProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &featureFlagsProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *featureFlagsProtobufClient) IsEnabled(ctx context.Context, in *IsEnabledReq) (*IsEnabledResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "FeatureFlags")
	ctx = ctxsetters.WithMethodName(ctx, "IsEnabled")
	out := new(IsEnabledResp)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *featureFlagsProtobufClient) Enable(ctx context.Context, in *EnableReq) (*EnableResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "FeatureFlags")
	ctx = ctxsetters.WithMethodName(ctx, "Enable")
	out := new(EnableResp)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *featureFlagsProtobufClient) Disable(ctx context.Context, in *DisableReq) (*DisableResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "FeatureFlags")
	ctx = ctxsetters.WithMethodName(ctx, "Disable")
	out := new(DisableResp)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *featureFlagsProtobufClient) List(ctx context.Context, in *ListFeatureFlagsReq) (*ListFeatureFlagsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "FeatureFlags")
	ctx = ctxsetters.WithMethodName(ctx, "List")
	out := new(ListFeatureFlagsResp)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *featureFlagsProtobufClient) Create(ctx context.Context, in *CreateFeatureFlagsReq) (*CreateFeatureFlagsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "FeatureFlags")
	ctx = ctxsetters.WithMethodName(ctx, "Create")
	out := new(CreateFeatureFlagsResp)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *featureFlagsProtobufClient) Delete(ctx context.Context, in *DeleteFeatureFlagsReq) (*DeleteFeatureFlagsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "FeatureFlags")
	ctx = ctxsetters.WithMethodName(ctx, "Delete")
	out := new(DeleteFeatureFlagsResp)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

// ========================
// FeatureFlags JSON Client
// ========================

type featureFlagsJSONClient struct {
	client HTTPClient
	urls   [6]string
}

// NewFeatureFlagsJSONClient creates a JSON client that implements the FeatureFlags interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewFeatureFlagsJSONClient(addr string, client HTTPClient) FeatureFlags {
	prefix := urlBase(addr) + FeatureFlagsPathPrefix
	urls := [6]string{
		prefix + "IsEnabled",
		prefix + "Enable",
		prefix + "Disable",
		prefix + "List",
		prefix + "Create",
		prefix + "Delete",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &featureFlagsJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &featureFlagsJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *featureFlagsJSONClient) IsEnabled(ctx context.Context, in *IsEnabledReq) (*IsEnabledResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "FeatureFlags")
	ctx = ctxsetters.WithMethodName(ctx, "IsEnabled")
	out := new(IsEnabledResp)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *featureFlagsJSONClient) Enable(ctx context.Context, in *EnableReq) (*EnableResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "FeatureFlags")
	ctx = ctxsetters.WithMethodName(ctx, "Enable")
	out := new(EnableResp)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *featureFlagsJSONClient) Disable(ctx context.Context, in *DisableReq) (*DisableResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "FeatureFlags")
	ctx = ctxsetters.WithMethodName(ctx, "Disable")
	out := new(DisableResp)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *featureFlagsJSONClient) List(ctx context.Context, in *ListFeatureFlagsReq) (*ListFeatureFlagsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "FeatureFlags")
	ctx = ctxsetters.WithMethodName(ctx, "List")
	out := new(ListFeatureFlagsResp)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *featureFlagsJSONClient) Create(ctx context.Context, in *CreateFeatureFlagsReq) (*CreateFeatureFlagsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "FeatureFlags")
	ctx = ctxsetters.WithMethodName(ctx, "Create")
	out := new(CreateFeatureFlagsResp)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *featureFlagsJSONClient) Delete(ctx context.Context, in *DeleteFeatureFlagsReq) (*DeleteFeatureFlagsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "FeatureFlags")
	ctx = ctxsetters.WithMethodName(ctx, "Delete")
	out := new(DeleteFeatureFlagsResp)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

// ===========================
// FeatureFlags Server Handler
// ===========================

type featureFlagsServer struct {
	FeatureFlags
	hooks *twirp.ServerHooks
}

func NewFeatureFlagsServer(svc FeatureFlags, hooks *twirp.ServerHooks) TwirpServer {
	return &featureFlagsServer{
		FeatureFlags: svc,
		hooks:        hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *featureFlagsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// FeatureFlagsPathPrefix is used for all URL paths on a twirp FeatureFlags server.
// Requests are always: POST FeatureFlagsPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const FeatureFlagsPathPrefix = "/twirp/code.justin.tv.eventbus.controlplane.FeatureFlags/"

func (s *featureFlagsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "FeatureFlags")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.eventbus.controlplane.FeatureFlags/IsEnabled":
		s.serveIsEnabled(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.FeatureFlags/Enable":
		s.serveEnable(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.FeatureFlags/Disable":
		s.serveDisable(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.FeatureFlags/List":
		s.serveList(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.FeatureFlags/Create":
		s.serveCreate(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.FeatureFlags/Delete":
		s.serveDelete(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *featureFlagsServer) serveIsEnabled(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveIsEnabledJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveIsEnabledProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *featureFlagsServer) serveIsEnabledJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsEnabled")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(IsEnabledReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *IsEnabledResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.IsEnabled(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IsEnabledResp and nil error while calling IsEnabled. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *featureFlagsServer) serveIsEnabledProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsEnabled")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(IsEnabledReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *IsEnabledResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.IsEnabled(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IsEnabledResp and nil error while calling IsEnabled. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *featureFlagsServer) serveEnable(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEnableJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEnableProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *featureFlagsServer) serveEnableJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Enable")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EnableReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EnableResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Enable(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EnableResp and nil error while calling Enable. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *featureFlagsServer) serveEnableProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Enable")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EnableReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EnableResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Enable(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EnableResp and nil error while calling Enable. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *featureFlagsServer) serveDisable(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDisableJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDisableProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *featureFlagsServer) serveDisableJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Disable")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DisableReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DisableResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Disable(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DisableResp and nil error while calling Disable. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *featureFlagsServer) serveDisableProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Disable")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DisableReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DisableResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Disable(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DisableResp and nil error while calling Disable. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *featureFlagsServer) serveList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *featureFlagsServer) serveListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "List")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListFeatureFlagsReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListFeatureFlagsResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.List(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListFeatureFlagsResp and nil error while calling List. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *featureFlagsServer) serveListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "List")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListFeatureFlagsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListFeatureFlagsResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.List(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListFeatureFlagsResp and nil error while calling List. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *featureFlagsServer) serveCreate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *featureFlagsServer) serveCreateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Create")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateFeatureFlagsReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateFeatureFlagsResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Create(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateFeatureFlagsResp and nil error while calling Create. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *featureFlagsServer) serveCreateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Create")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateFeatureFlagsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateFeatureFlagsResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Create(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateFeatureFlagsResp and nil error while calling Create. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *featureFlagsServer) serveDelete(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *featureFlagsServer) serveDeleteJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Delete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteFeatureFlagsReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteFeatureFlagsResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Delete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteFeatureFlagsResp and nil error while calling Delete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *featureFlagsServer) serveDeleteProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Delete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteFeatureFlagsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteFeatureFlagsResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Delete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteFeatureFlagsResp and nil error while calling Delete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *featureFlagsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor1, 0
}

func (s *featureFlagsServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

var twirpFileDescriptor1 = []byte{
	// 426 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x94, 0x41, 0x6f, 0xd3, 0x30,
	0x14, 0xc7, 0x95, 0x6e, 0x2b, 0xe4, 0x25, 0xe5, 0xf0, 0xa0, 0x53, 0x14, 0x09, 0x11, 0x59, 0x1c,
	0x22, 0x21, 0x39, 0xac, 0x3b, 0x01, 0x3b, 0x20, 0x18, 0x93, 0x90, 0x38, 0x45, 0x88, 0x03, 0x97,
	0x29, 0x4d, 0xdc, 0x29, 0x90, 0x39, 0x5e, 0x9e, 0xdb, 0x1b, 0x27, 0xbe, 0x2e, 0x1f, 0x02, 0xd1,
	0xb4, 0xc5, 0xa5, 0x06, 0xdc, 0xde, 0x5c, 0xeb, 0xfd, 0xde, 0xfb, 0xfb, 0xf5, 0xa7, 0xc0, 0x45,
	0xd9, 0x56, 0x82, 0x7f, 0x99, 0x93, 0xae, 0x25, 0xd7, 0x8b, 0x4c, 0x2c, 0x84, 0xd4, 0xd3, 0x39,
	0x65, 0x65, 0x2b, 0x75, 0xd7, 0x36, 0xaa, 0x29, 0xa4, 0xc8, 0x3a, 0x55, 0x66, 0x33, 0x51, 0xe8,
	0x79, 0x27, 0xae, 0x67, 0x4d, 0x71, 0x43, 0x5c, 0x75, 0xad, 0x6e, 0xf1, 0xe9, 0x36, 0xcd, 0xd7,
	0x34, 0x37, 0x69, 0xc6, 0x20, 0x7c, 0x4f, 0xef, 0x64, 0x31, 0x6d, 0x44, 0x95, 0x8b, 0x3b, 0x44,
	0x38, 0x96, 0xc5, 0xad, 0x88, 0xbc, 0xc4, 0x4b, 0xfd, 0x7c, 0x79, 0x66, 0x1c, 0x46, 0x46, 0x0d,
	0x29, 0x7c, 0x0c, 0x50, 0xd3, 0xb5, 0xe8, 0x6f, 0xa2, 0x41, 0xe2, 0xa5, 0xf7, 0x73, 0xbf, 0x5e,
	0x97, 0xb0, 0x27, 0xe0, 0xf7, 0xc7, 0xbf, 0x35, 0x0c, 0x01, 0xd6, 0x05, 0xa4, 0x58, 0x02, 0x70,
	0x59, 0xd3, 0xbf, 0xea, 0x47, 0x10, 0x6c, 0x2a, 0x48, 0xb1, 0xd7, 0x10, 0x5c, 0xf5, 0x0f, 0xbe,
	0x6a, 0x8a, 0x1b, 0x1b, 0xf1, 0xbf, 0x84, 0x63, 0x78, 0xf8, 0xa1, 0x26, 0x6d, 0x74, 0xa1, 0x5c,
	0xdc, 0x31, 0x09, 0x8f, 0x76, 0xaf, 0x49, 0xe1, 0x27, 0x18, 0x6d, 0x6d, 0x38, 0xf2, 0x92, 0xa3,
	0x34, 0x98, 0x9c, 0x71, 0x97, 0x15, 0x73, 0xa3, 0x5d, 0x1e, 0xce, 0x8c, 0xde, 0xec, 0x16, 0xc6,
	0x6f, 0x3b, 0x51, 0x68, 0xf1, 0x47, 0x10, 0xfc, 0x08, 0xa1, 0x39, 0x70, 0xf9, 0xb4, 0x83, 0xe6,
	0x05, 0xc6, 0x3c, 0x96, 0xc2, 0xa9, 0x6d, 0x1c, 0x29, 0x7c, 0x00, 0x83, 0xba, 0x5a, 0x2d, 0x70,
	0x50, 0x57, 0xec, 0x19, 0x8c, 0x2f, 0x45, 0x23, 0x76, 0x83, 0xd9, 0xfe, 0x9d, 0x08, 0x4e, 0x6d,
	0xc5, 0xa4, 0x26, 0x3f, 0x4e, 0x20, 0x34, 0x2f, 0x51, 0x83, 0xbf, 0x31, 0x09, 0x27, 0x6e, 0xcf,
	0x31, 0xf5, 0x8c, 0xcf, 0xf7, 0x66, 0x48, 0xe1, 0x57, 0x18, 0xf6, 0x3f, 0x31, 0x73, 0xc3, 0x37,
	0xf6, 0xc6, 0xcf, 0xf7, 0x03, 0x48, 0xa1, 0x84, 0x7b, 0x2b, 0x57, 0xd1, 0x11, 0xfe, 0x2d, 0x7f,
	0x7c, 0xb6, 0x27, 0x41, 0x0a, 0xbf, 0xc1, 0xf1, 0x2f, 0x67, 0xf1, 0x85, 0x1b, 0x6a, 0xd1, 0x3e,
	0x7e, 0x79, 0x28, 0x4a, 0x0a, 0xbf, 0x7b, 0x30, 0xec, 0xa5, 0xc2, 0x57, 0x6e, 0x6d, 0xac, 0xc6,
	0xc7, 0x17, 0x87, 0xc3, 0xab, 0x14, 0xbd, 0x83, 0xae, 0x29, 0xac, 0x7a, 0xbb, 0xa6, 0xb0, 0xeb,
	0xfe, 0xe6, 0xe4, 0xf3, 0x51, 0xa7, 0xca, 0xe9, 0x70, 0xf9, 0xfd, 0x3d, 0xff, 0x19, 0x00, 0x00,
	0xff, 0xff, 0x09, 0x60, 0x85, 0x7d, 0xbf, 0x05, 0x00, 0x00,
}
