// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: code.justin.tv/eventbus/controlplane/rpc/subscriptions.proto

package rpc

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// =======================
// Subscriptions Interface
// =======================

type Subscriptions interface {
	Create(context.Context, *CreateSubscriptionReq) (*CreateSubscriptionResp, error)

	Delete(context.Context, *DeleteSubscriptionReq) (*DeleteSubscriptionResp, error)

	GetSubscriptionsForTarget(context.Context, *GetSubscriptionsForTargetReq) (*GetSubscriptionsForTargetResp, error)
}

// =============================
// Subscriptions Protobuf Client
// =============================

type subscriptionsProtobufClient struct {
	client HTTPClient
	urls   [3]string
}

// NewSubscriptionsProtobufClient creates a Protobuf client that implements the Subscriptions interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewSubscriptionsProtobufClient(addr string, client HTTPClient) Subscriptions {
	prefix := urlBase(addr) + SubscriptionsPathPrefix
	urls := [3]string{
		prefix + "Create",
		prefix + "Delete",
		prefix + "GetSubscriptionsForTarget",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &subscriptionsProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &subscriptionsProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *subscriptionsProtobufClient) Create(ctx context.Context, in *CreateSubscriptionReq) (*CreateSubscriptionResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Subscriptions")
	ctx = ctxsetters.WithMethodName(ctx, "Create")
	out := new(CreateSubscriptionResp)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) Delete(ctx context.Context, in *DeleteSubscriptionReq) (*DeleteSubscriptionResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Subscriptions")
	ctx = ctxsetters.WithMethodName(ctx, "Delete")
	out := new(DeleteSubscriptionResp)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetSubscriptionsForTarget(ctx context.Context, in *GetSubscriptionsForTargetReq) (*GetSubscriptionsForTargetResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Subscriptions")
	ctx = ctxsetters.WithMethodName(ctx, "GetSubscriptionsForTarget")
	out := new(GetSubscriptionsForTargetResp)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

// =========================
// Subscriptions JSON Client
// =========================

type subscriptionsJSONClient struct {
	client HTTPClient
	urls   [3]string
}

// NewSubscriptionsJSONClient creates a JSON client that implements the Subscriptions interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewSubscriptionsJSONClient(addr string, client HTTPClient) Subscriptions {
	prefix := urlBase(addr) + SubscriptionsPathPrefix
	urls := [3]string{
		prefix + "Create",
		prefix + "Delete",
		prefix + "GetSubscriptionsForTarget",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &subscriptionsJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &subscriptionsJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *subscriptionsJSONClient) Create(ctx context.Context, in *CreateSubscriptionReq) (*CreateSubscriptionResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Subscriptions")
	ctx = ctxsetters.WithMethodName(ctx, "Create")
	out := new(CreateSubscriptionResp)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *subscriptionsJSONClient) Delete(ctx context.Context, in *DeleteSubscriptionReq) (*DeleteSubscriptionResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Subscriptions")
	ctx = ctxsetters.WithMethodName(ctx, "Delete")
	out := new(DeleteSubscriptionResp)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetSubscriptionsForTarget(ctx context.Context, in *GetSubscriptionsForTargetReq) (*GetSubscriptionsForTargetResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Subscriptions")
	ctx = ctxsetters.WithMethodName(ctx, "GetSubscriptionsForTarget")
	out := new(GetSubscriptionsForTargetResp)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

// ============================
// Subscriptions Server Handler
// ============================

type subscriptionsServer struct {
	Subscriptions
	hooks *twirp.ServerHooks
}

func NewSubscriptionsServer(svc Subscriptions, hooks *twirp.ServerHooks) TwirpServer {
	return &subscriptionsServer{
		Subscriptions: svc,
		hooks:         hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *subscriptionsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// SubscriptionsPathPrefix is used for all URL paths on a twirp Subscriptions server.
// Requests are always: POST SubscriptionsPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const SubscriptionsPathPrefix = "/twirp/code.justin.tv.eventbus.controlplane.Subscriptions/"

func (s *subscriptionsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Subscriptions")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.eventbus.controlplane.Subscriptions/Create":
		s.serveCreate(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.Subscriptions/Delete":
		s.serveDelete(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.Subscriptions/GetSubscriptionsForTarget":
		s.serveGetSubscriptionsForTarget(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *subscriptionsServer) serveCreate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Create")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateSubscriptionReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateSubscriptionResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Create(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateSubscriptionResp and nil error while calling Create. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *subscriptionsServer) serveCreateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Create")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateSubscriptionReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateSubscriptionResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Create(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateSubscriptionResp and nil error while calling Create. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *subscriptionsServer) serveDelete(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveDeleteJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Delete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteSubscriptionReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteSubscriptionResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Delete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteSubscriptionResp and nil error while calling Delete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *subscriptionsServer) serveDeleteProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Delete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteSubscriptionReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteSubscriptionResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Delete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteSubscriptionResp and nil error while calling Delete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *subscriptionsServer) serveGetSubscriptionsForTarget(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetSubscriptionsForTargetJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSubscriptionsForTargetProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetSubscriptionsForTargetJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSubscriptionsForTarget")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetSubscriptionsForTargetReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSubscriptionsForTargetResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetSubscriptionsForTarget(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSubscriptionsForTargetResp and nil error while calling GetSubscriptionsForTarget. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *subscriptionsServer) serveGetSubscriptionsForTargetProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSubscriptionsForTarget")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetSubscriptionsForTargetReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSubscriptionsForTargetResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetSubscriptionsForTarget(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSubscriptionsForTargetResp and nil error while calling GetSubscriptionsForTarget. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *subscriptionsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor5, 0
}

func (s *subscriptionsServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

var twirpFileDescriptor5 = []byte{
	// 532 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x55, 0xcd, 0x6e, 0xd3, 0x40,
	0x10, 0xc6, 0x71, 0x93, 0x36, 0xd3, 0x1f, 0x59, 0x23, 0x51, 0x99, 0xfe, 0x08, 0x13, 0x0a, 0x54,
	0x1c, 0x1c, 0x29, 0x5c, 0x90, 0xda, 0x4b, 0x7e, 0x4c, 0x15, 0x51, 0x39, 0x91, 0xed, 0x00, 0xe2,
	0x12, 0x25, 0xf6, 0xaa, 0x32, 0x4a, 0xed, 0xc5, 0xbb, 0x8e, 0x94, 0x33, 0x37, 0x9e, 0x83, 0x27,
	0xe1, 0x69, 0x78, 0x0c, 0xc4, 0x3a, 0x41, 0x36, 0x75, 0x5c, 0xd3, 0x4a, 0x3d, 0x7a, 0xf6, 0xfb,
	0x9b, 0xdd, 0x19, 0x19, 0xce, 0xdd, 0xd0, 0x23, 0xfa, 0x97, 0x98, 0x71, 0x3f, 0xd0, 0xf9, 0xbc,
	0x49, 0xe6, 0x24, 0xe0, 0xd3, 0x98, 0x35, 0xdd, 0x30, 0xe0, 0x51, 0x38, 0xa3, 0xb3, 0x49, 0x40,
	0x9a, 0x11, 0x75, 0x9b, 0x2c, 0x9e, 0x32, 0x37, 0xf2, 0x29, 0xf7, 0xc3, 0x80, 0xe9, 0x34, 0x0a,
	0x79, 0x88, 0x27, 0x59, 0xb6, 0xbe, 0x62, 0xeb, 0x69, 0x76, 0xe3, 0x97, 0x04, 0x3b, 0x76, 0x8a,
	0x8d, 0x87, 0x50, 0xe7, 0x93, 0xe8, 0x8a, 0xf0, 0xb1, 0xef, 0xa9, 0x92, 0x26, 0x9d, 0xd6, 0xad,
	0xad, 0xa4, 0xd0, 0xf7, 0xf0, 0x18, 0x40, 0xc8, 0x8c, 0xf9, 0x82, 0x12, 0xb5, 0x22, 0x4e, 0xeb,
	0xa2, 0xe2, 0x2c, 0x28, 0xc1, 0x3d, 0xa8, 0xf8, 0x9e, 0x2a, 0x8b, 0x72, 0xc5, 0xf7, 0x70, 0x08,
	0x35, 0xc6, 0x27, 0x3c, 0x66, 0xea, 0x86, 0x26, 0x9d, 0xee, 0xb5, 0xde, 0xea, 0x65, 0x32, 0xe9,
	0xe9, 0x3c, 0xb6, 0xe0, 0x5b, 0x4b, 0x1d, 0x54, 0x61, 0xf3, 0x9a, 0x30, 0x36, 0xb9, 0x22, 0x6a,
	0x55, 0xd8, 0xac, 0x3e, 0x51, 0x83, 0x6d, 0x12, 0xcc, 0xfd, 0x28, 0x0c, 0xae, 0x49, 0xc0, 0xd5,
	0x9a, 0x38, 0x4d, 0x97, 0x1a, 0x31, 0x3c, 0xee, 0x46, 0x64, 0xc2, 0x49, 0x5a, 0xdf, 0x22, 0x5f,
	0xef, 0xd5, 0xf2, 0x3f, 0xb6, 0xf2, 0x4d, 0x5b, 0x0a, 0xfb, 0x79, 0xb6, 0x8c, 0xe2, 0x07, 0xd8,
	0x49, 0x3f, 0x9c, 0xb0, 0xde, 0x6e, 0xb5, 0xfe, 0xff, 0x92, 0xac, 0x8c, 0xce, 0x9f, 0x46, 0x7b,
	0x64, 0x46, 0x1e, 0xba, 0x51, 0x15, 0xf6, 0xf3, 0x6c, 0x19, 0x6d, 0x9c, 0xc1, 0xd1, 0x05, 0xe1,
	0xe9, 0x32, 0x7b, 0x17, 0x46, 0x8e, 0x70, 0xbe, 0x2d, 0x57, 0x63, 0x01, 0xc7, 0x05, 0x64, 0x46,
	0xf1, 0x13, 0xec, 0x66, 0xe6, 0x5f, 0xad, 0x68, 0xf2, 0x1d, 0xef, 0x31, 0x2b, 0xf4, 0xfa, 0xbb,
	0x0c, 0x78, 0x73, 0x18, 0xf1, 0x29, 0x1c, 0xda, 0xa3, 0x8e, 0xdd, 0xb5, 0xfa, 0x43, 0xa7, 0x3f,
	0x30, 0xc7, 0xb6, 0xd3, 0x76, 0x46, 0xf6, 0x78, 0x64, 0xbe, 0x37, 0x07, 0x1f, 0x4d, 0xe5, 0x11,
	0x6a, 0x70, 0x94, 0x07, 0xe8, 0xf5, 0xed, 0x76, 0xe7, 0xd2, 0xe8, 0x29, 0xd2, 0x3a, 0x09, 0xc3,
	0x4c, 0x00, 0x15, 0x7c, 0x05, 0xcf, 0xf3, 0x00, 0x43, 0xc3, 0xec, 0xf5, 0xcd, 0x8b, 0x95, 0x94,
	0x22, 0xe3, 0x4b, 0x68, 0x14, 0x01, 0x13, 0x45, 0x65, 0x03, 0x5f, 0xc0, 0xb3, 0x5c, 0x47, 0xcb,
	0x1a, 0x58, 0x7f, 0xe5, 0xaa, 0x78, 0x02, 0xda, 0x7a, 0xd8, 0x52, 0xac, 0x56, 0x8c, 0xea, 0x5a,
	0x46, 0xdb, 0x31, 0x94, 0xcd, 0xdb, 0xa2, 0xf5, 0x8c, 0x4b, 0xc3, 0x31, 0x94, 0xad, 0x62, 0xb5,
	0x25, 0xaa, 0xde, 0xfa, 0x29, 0xc3, 0x6e, 0x66, 0x0a, 0xf0, 0x9b, 0x04, 0xb5, 0x64, 0xb5, 0xf0,
	0xac, 0xdc, 0x63, 0xe7, 0xee, 0xff, 0xc1, 0xf9, 0xdd, 0xc9, 0x8c, 0x8a, 0x14, 0xc9, 0xdc, 0x97,
	0x4d, 0x91, 0xbb, 0x9c, 0x65, 0x53, 0xe4, 0xaf, 0x18, 0xfe, 0x90, 0xe0, 0xc9, 0xda, 0x35, 0xc1,
	0x4e, 0x39, 0xed, 0xa2, 0x25, 0x3d, 0xe8, 0xde, 0x5b, 0x83, 0xd1, 0x4e, 0xf5, 0xb3, 0x1c, 0x51,
	0x77, 0x5a, 0x13, 0xbf, 0xa8, 0x37, 0xbf, 0x03, 0x00, 0x00, 0xff, 0xff, 0x2b, 0x74, 0x85, 0xaf,
	0xe2, 0x06, 0x00, 0x00,
}
