// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: code.justin.tv/eventbus/controlplane/rpc/targets.proto

package rpc

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// =================
// Targets Interface
// =================

type Targets interface {
	Create(context.Context, *CreateTargetReq) (*CreateTargetResp, error)

	GetTargetsForService(context.Context, *GetTargetsForServiceReq) (*GetTargetsForServiceResp, error)

	Delete(context.Context, *DeleteTargetReq) (*DeleteTargetResp, error)

	Validate(context.Context, *ValidateTargetReq) (*ValidateTargetResp, error)
}

// =======================
// Targets Protobuf Client
// =======================

type targetsProtobufClient struct {
	client HTTPClient
	urls   [4]string
}

// NewTargetsProtobufClient creates a Protobuf client that implements the Targets interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTargetsProtobufClient(addr string, client HTTPClient) Targets {
	prefix := urlBase(addr) + TargetsPathPrefix
	urls := [4]string{
		prefix + "Create",
		prefix + "GetTargetsForService",
		prefix + "Delete",
		prefix + "Validate",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &targetsProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &targetsProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *targetsProtobufClient) Create(ctx context.Context, in *CreateTargetReq) (*CreateTargetResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Targets")
	ctx = ctxsetters.WithMethodName(ctx, "Create")
	out := new(CreateTargetResp)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *targetsProtobufClient) GetTargetsForService(ctx context.Context, in *GetTargetsForServiceReq) (*GetTargetsForServiceResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Targets")
	ctx = ctxsetters.WithMethodName(ctx, "GetTargetsForService")
	out := new(GetTargetsForServiceResp)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *targetsProtobufClient) Delete(ctx context.Context, in *DeleteTargetReq) (*DeleteTargetResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Targets")
	ctx = ctxsetters.WithMethodName(ctx, "Delete")
	out := new(DeleteTargetResp)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *targetsProtobufClient) Validate(ctx context.Context, in *ValidateTargetReq) (*ValidateTargetResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Targets")
	ctx = ctxsetters.WithMethodName(ctx, "Validate")
	out := new(ValidateTargetResp)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

// ===================
// Targets JSON Client
// ===================

type targetsJSONClient struct {
	client HTTPClient
	urls   [4]string
}

// NewTargetsJSONClient creates a JSON client that implements the Targets interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTargetsJSONClient(addr string, client HTTPClient) Targets {
	prefix := urlBase(addr) + TargetsPathPrefix
	urls := [4]string{
		prefix + "Create",
		prefix + "GetTargetsForService",
		prefix + "Delete",
		prefix + "Validate",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &targetsJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &targetsJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *targetsJSONClient) Create(ctx context.Context, in *CreateTargetReq) (*CreateTargetResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Targets")
	ctx = ctxsetters.WithMethodName(ctx, "Create")
	out := new(CreateTargetResp)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *targetsJSONClient) GetTargetsForService(ctx context.Context, in *GetTargetsForServiceReq) (*GetTargetsForServiceResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Targets")
	ctx = ctxsetters.WithMethodName(ctx, "GetTargetsForService")
	out := new(GetTargetsForServiceResp)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *targetsJSONClient) Delete(ctx context.Context, in *DeleteTargetReq) (*DeleteTargetResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Targets")
	ctx = ctxsetters.WithMethodName(ctx, "Delete")
	out := new(DeleteTargetResp)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *targetsJSONClient) Validate(ctx context.Context, in *ValidateTargetReq) (*ValidateTargetResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Targets")
	ctx = ctxsetters.WithMethodName(ctx, "Validate")
	out := new(ValidateTargetResp)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

// ======================
// Targets Server Handler
// ======================

type targetsServer struct {
	Targets
	hooks *twirp.ServerHooks
}

func NewTargetsServer(svc Targets, hooks *twirp.ServerHooks) TwirpServer {
	return &targetsServer{
		Targets: svc,
		hooks:   hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *targetsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TargetsPathPrefix is used for all URL paths on a twirp Targets server.
// Requests are always: POST TargetsPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TargetsPathPrefix = "/twirp/code.justin.tv.eventbus.controlplane.Targets/"

func (s *targetsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Targets")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.eventbus.controlplane.Targets/Create":
		s.serveCreate(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.Targets/GetTargetsForService":
		s.serveGetTargetsForService(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.Targets/Delete":
		s.serveDelete(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.Targets/Validate":
		s.serveValidate(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *targetsServer) serveCreate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *targetsServer) serveCreateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Create")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateTargetReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateTargetResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Create(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateTargetResp and nil error while calling Create. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *targetsServer) serveCreateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Create")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateTargetReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateTargetResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Create(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateTargetResp and nil error while calling Create. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *targetsServer) serveGetTargetsForService(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetTargetsForServiceJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTargetsForServiceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *targetsServer) serveGetTargetsForServiceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTargetsForService")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetTargetsForServiceReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetTargetsForServiceResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetTargetsForService(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTargetsForServiceResp and nil error while calling GetTargetsForService. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *targetsServer) serveGetTargetsForServiceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTargetsForService")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetTargetsForServiceReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetTargetsForServiceResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetTargetsForService(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTargetsForServiceResp and nil error while calling GetTargetsForService. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *targetsServer) serveDelete(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *targetsServer) serveDeleteJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Delete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteTargetReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteTargetResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Delete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteTargetResp and nil error while calling Delete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *targetsServer) serveDeleteProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Delete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteTargetReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteTargetResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Delete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteTargetResp and nil error while calling Delete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *targetsServer) serveValidate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveValidateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveValidateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *targetsServer) serveValidateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Validate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ValidateTargetReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ValidateTargetResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Validate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ValidateTargetResp and nil error while calling Validate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *targetsServer) serveValidateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Validate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ValidateTargetReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ValidateTargetResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Validate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ValidateTargetResp and nil error while calling Validate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *targetsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor3, 0
}

func (s *targetsServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

var twirpFileDescriptor3 = []byte{
	// 909 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xdd, 0x6e, 0xdb, 0x36,
	0x18, 0xad, 0x65, 0xd9, 0x96, 0x3e, 0x27, 0x8e, 0xca, 0x04, 0xad, 0x90, 0x61, 0x40, 0xa6, 0x75,
	0x43, 0x57, 0x0c, 0x76, 0x97, 0x6e, 0x6d, 0x6f, 0x36, 0xc0, 0xa9, 0x14, 0x27, 0x59, 0xe2, 0x26,
	0xb2, 0xb2, 0xbf, 0x1b, 0x41, 0x91, 0xd8, 0x56, 0x83, 0x22, 0xc9, 0x22, 0x95, 0xa0, 0x17, 0xbb,
	0xd8, 0x2b, 0x0c, 0xd8, 0x0b, 0xed, 0x6e, 0xaf, 0xb0, 0xa7, 0x19, 0x48, 0x4a, 0x91, 0xec, 0xa6,
	0xa8, 0x9a, 0xdc, 0x99, 0xe7, 0xd3, 0x39, 0x1f, 0x79, 0xf8, 0xf1, 0x24, 0xf0, 0xd4, 0x4f, 0x02,
	0x3c, 0xfc, 0x3d, 0x27, 0x34, 0x8c, 0x87, 0xf4, 0x62, 0x84, 0x2f, 0x70, 0x4c, 0xcf, 0x72, 0x32,
	0xf2, 0x93, 0x98, 0x66, 0x49, 0x94, 0x46, 0x5e, 0x8c, 0x47, 0x59, 0xea, 0x8f, 0xa8, 0x97, 0xbd,
	0xc6, 0x94, 0x0c, 0xd3, 0x2c, 0xa1, 0x09, 0x7a, 0xb0, 0xc8, 0x1b, 0x96, 0xbc, 0x61, 0x9d, 0x67,
	0xfc, 0x27, 0x41, 0xd7, 0xe1, 0x3c, 0x34, 0x00, 0x29, 0x0c, 0xf4, 0xd6, 0x56, 0xeb, 0xa1, 0x6a,
	0x4b, 0x61, 0x80, 0x3e, 0x05, 0x20, 0x38, 0xbb, 0x08, 0x7d, 0xec, 0x86, 0x81, 0x2e, 0x71, 0x5c,
	0x2d, 0x90, 0xfd, 0x00, 0x99, 0xd0, 0x26, 0x73, 0xa2, 0xb7, 0xb7, 0x5a, 0x0f, 0xfb, 0xdb, 0x8f,
	0x87, 0x4d, 0xba, 0x0d, 0x67, 0x27, 0x33, 0x13, 0x53, 0x2f, 0x8c, 0xc8, 0xde, 0x1d, 0x9b, 0xd1,
	0xd1, 0x04, 0xe4, 0x37, 0x94, 0xa6, 0xba, 0xcc, 0x65, 0xbe, 0x69, 0x26, 0xb3, 0xe7, 0x38, 0xc7,
	0x95, 0x0e, 0x17, 0x40, 0x47, 0xd0, 0x8d, 0xbc, 0xf3, 0xb3, 0xc0, 0xd3, 0x3b, 0x5c, 0xea, 0x49,
	0x33, 0xa9, 0x43, 0xce, 0xa9, 0xc4, 0x0a, 0x11, 0x84, 0x40, 0x8e, 0xbd, 0x73, 0xac, 0x77, 0xf9,
	0xb1, 0xf9, 0x6f, 0xf4, 0x00, 0x06, 0xde, 0x25, 0x71, 0x3d, 0xdf, 0x4f, 0xf2, 0x98, 0x32, 0x53,
	0x7a, 0xbc, 0xba, 0xe2, 0x5d, 0x92, 0xb1, 0x00, 0xf7, 0x83, 0x1d, 0x15, 0x7a, 0x81, 0x90, 0x33,
	0xfe, 0x91, 0x60, 0xed, 0x45, 0x86, 0x3d, 0x8a, 0x85, 0xc5, 0x36, 0x9e, 0x2f, 0xb9, 0xda, 0x5a,
	0x76, 0xb5, 0xec, 0x2b, 0xd5, 0xfa, 0x9a, 0x20, 0xd3, 0xb7, 0x29, 0xe6, 0x56, 0x0f, 0x9a, 0x5a,
	0x2d, 0x3a, 0x3a, 0x6f, 0x53, 0x6c, 0x73, 0x36, 0xfa, 0x1c, 0x56, 0x99, 0x51, 0x2e, 0x8e, 0x83,
	0x34, 0x09, 0x63, 0xca, 0x7d, 0x52, 0xed, 0x15, 0x06, 0x5a, 0x05, 0x86, 0x86, 0xb0, 0x2e, 0x0c,
	0x70, 0x5f, 0xe5, 0xb1, 0x4f, 0xc3, 0x24, 0x76, 0xbd, 0x2c, 0x2e, 0x5c, 0xb8, 0x2b, 0x4a, 0xbb,
	0x45, 0x65, 0x9c, 0xc5, 0xe5, 0x10, 0xa8, 0xb7, 0x1a, 0x82, 0x9a, 0x65, 0x07, 0xb2, 0x22, 0x6b,
	0x9d, 0x03, 0x59, 0xe9, 0x69, 0xca, 0x81, 0xac, 0x28, 0x9a, 0x6a, 0xfc, 0x02, 0xda, 0xa2, 0x87,
	0x24, 0x45, 0x26, 0x74, 0xc5, 0xb0, 0x73, 0x03, 0xfb, 0xdb, 0x5f, 0x7f, 0x8c, 0x27, 0x76, 0xc1,
	0x35, 0x26, 0xb0, 0x66, 0xe2, 0x08, 0xd7, 0x6f, 0xe7, 0x5b, 0xb8, 0x47, 0xf2, 0x33, 0xe2, 0x67,
	0x61, 0xca, 0x0f, 0x2f, 0xbe, 0xac, 0x6e, 0x6a, 0xa3, 0x5e, 0x15, 0xb4, 0xfd, 0xc0, 0xd8, 0x03,
	0x6d, 0x51, 0x88, 0xa4, 0x37, 0x54, 0x7a, 0x0e, 0xf7, 0x27, 0x98, 0x8a, 0x25, 0xd9, 0x4d, 0xb2,
	0x99, 0x18, 0x8c, 0x0f, 0x0f, 0x8e, 0xf1, 0x67, 0x0b, 0xf4, 0xeb, 0xa9, 0x24, 0xfd, 0xd0, 0xd0,
	0xed, 0x42, 0xaf, 0xc8, 0x0e, 0x5d, 0xda, 0x6a, 0x7f, 0xb4, 0x9f, 0x25, 0xd9, 0x78, 0x06, 0x77,
	0x7f, 0xf2, 0xa2, 0x30, 0x58, 0x18, 0x78, 0x03, 0x56, 0xc9, 0x9c, 0xb8, 0xf3, 0x1c, 0xe7, 0xd8,
	0xcd, 0xb3, 0xa8, 0x68, 0xdf, 0x27, 0x73, 0x72, 0xc2, 0xb0, 0xd3, 0x2c, 0x32, 0xf6, 0x00, 0x2d,
	0x13, 0x49, 0x8a, 0x74, 0xe8, 0x85, 0x84, 0xe3, 0x9c, 0xa3, 0xd8, 0xe5, 0x92, 0x55, 0xce, 0x31,
	0x21, 0xde, 0xeb, 0xf2, 0xa1, 0x94, 0x4b, 0xe3, 0x5f, 0x09, 0xa0, 0x1a, 0x30, 0xf4, 0x25, 0xac,
	0x79, 0x84, 0xe4, 0xe7, 0xd8, 0xcd, 0x92, 0x08, 0xf3, 0x59, 0x16, 0xed, 0x57, 0x05, 0x6c, 0x27,
	0x11, 0x66, 0x73, 0xfc, 0x09, 0xa8, 0x62, 0x83, 0xec, 0x0b, 0x21, 0xa9, 0x70, 0x80, 0x15, 0xa7,
	0x00, 0xec, 0x04, 0x84, 0x7a, 0x34, 0x27, 0xc5, 0x2b, 0x1c, 0x35, 0x9e, 0xf5, 0x19, 0xa7, 0xd9,
	0x2a, 0x99, 0x13, 0xf1, 0x13, 0x7d, 0x01, 0x03, 0xa1, 0xe5, 0x96, 0x87, 0x90, 0xc5, 0x9e, 0x04,
	0x7a, 0x24, 0xc0, 0x6a, 0x4f, 0xcc, 0xb4, 0x4e, 0x6d, 0x4f, 0xa7, 0x59, 0x84, 0x1e, 0xc3, 0x46,
	0x80, 0xbd, 0x20, 0xc2, 0x94, 0xe2, 0xcc, 0xad, 0xf6, 0x2e, 0x5e, 0x2a, 0xaa, 0x6a, 0x27, 0xe5,
	0x29, 0xae, 0x63, 0x30, 0xe5, 0xde, 0xb5, 0x0c, 0x76, 0x2b, 0x5f, 0x41, 0xbf, 0x96, 0xb4, 0x68,
	0x13, 0x94, 0xab, 0xec, 0x10, 0x26, 0x5e, 0xad, 0x8d, 0x6d, 0x58, 0x5d, 0x48, 0x52, 0xf4, 0x19,
	0xac, 0x2c, 0x24, 0x48, 0x71, 0xe9, 0xaf, 0xaa, 0xec, 0x78, 0x84, 0x41, 0xbd, 0xb2, 0x07, 0xf5,
	0xa1, 0x77, 0x3a, 0xfd, 0x71, 0xfa, 0xf2, 0xe7, 0xa9, 0x76, 0x07, 0x21, 0x18, 0x1c, 0x5b, 0x53,
	0x73, 0x7f, 0x3a, 0x71, 0x5f, 0xd8, 0xd6, 0xd8, 0xb1, 0xb4, 0x56, 0x1d, 0x33, 0xad, 0x43, 0xcb,
	0xb1, 0x34, 0x89, 0x91, 0x44, 0xdd, 0xd4, 0xda, 0x6c, 0x21, 0x0a, 0xa6, 0x26, 0x23, 0x15, 0x3a,
	0x96, 0x6d, 0xbf, 0xb4, 0xb5, 0xce, 0xa3, 0x37, 0x00, 0x55, 0x16, 0xa2, 0xfb, 0xb0, 0xee, 0x8c,
	0xed, 0x89, 0xe5, 0xb8, 0xce, 0xaf, 0xc7, 0x96, 0x5b, 0xf5, 0x5c, 0x87, 0xb5, 0x7a, 0x61, 0x76,
	0x32, 0xd3, 0x5a, 0x68, 0x03, 0xb4, 0x3a, 0xc8, 0xdc, 0xd0, 0x24, 0x74, 0x0f, 0x50, 0x1d, 0x3d,
	0x1c, 0x1f, 0xed, 0x98, 0x63, 0xad, 0xbd, 0xfd, 0x97, 0x0c, 0xbd, 0xe2, 0xfd, 0xa1, 0x4b, 0xe8,
	0x8a, 0xd4, 0x42, 0xdf, 0x35, 0x9b, 0x94, 0xa5, 0xbf, 0x13, 0x9b, 0x4f, 0x6f, 0x42, 0x23, 0x29,
	0xfa, 0xbb, 0x05, 0x1b, 0xd7, 0xe5, 0x00, 0xfa, 0xbe, 0x99, 0xe0, 0x7b, 0xe2, 0x67, 0xf3, 0x87,
	0xdb, 0xd0, 0x49, 0xca, 0x0c, 0x11, 0x19, 0xd9, 0xd4, 0x90, 0xa5, 0x68, 0x6e, 0x6a, 0xc8, 0x3b,
	0x41, 0xfc, 0x07, 0x28, 0x65, 0xb6, 0xa0, 0x67, 0xcd, 0x34, 0xde, 0x09, 0xb1, 0xcd, 0xe7, 0x37,
	0x23, 0x92, 0x74, 0xa7, 0xf3, 0x5b, 0x3b, 0x4b, 0xfd, 0xb3, 0x2e, 0xff, 0xa7, 0xec, 0xc9, 0xff,
	0x01, 0x00, 0x00, 0xff, 0xff, 0x63, 0xab, 0x94, 0xa8, 0xce, 0x09, 0x00, 0x00,
}
