# Choosing a subscriber implementation

Publishing to event bus always happens via SNS. Because the technical 
needs of applications that receive messages are not identical, we've 
made it possible for subscribers to receive from the event bus using 
a couple of different subscriber implementations.

This document outlines the different implementations enabled, and the
pros and cons of each.


## SQS Poller

You can subscribe to one or more event bus streams into an SQS queue.
The key feature of SQS queues is delivery reliability.

**Pros**

* You control your application lifecycle and this code can be integrated into
  existing Go applications/services that might be handling other event sources
  such as HTTP/Twirp, other event streams, etc.
* Very cost effective vs lambda especially as message rates increase.

**Cons**

* Additional tuning may be required so that the message timeout length is 
  calibrated to your application. Otherwise, message retries may happen too 
  quickly or sometimes not quickly enough.
* Workers don't automatically scale up to load, you will need to implement 
  something like [autoscaling your workers based on queue backlog][sqs-autoscale].

[sqs-autoscale]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-using-sqs-queue.html

### When to use the SQS poller

The SQS poller should be used when you want full control over your application or
are integrating this into an existing application.

It should also be used if you have a long processing flow (in wallclock time) 
for your messages. Lambda is designed for tasks that run a few seconds or so tops. 
SQS supports workflows that only ACK a message once you've completed a relatively
large task.

Another case for using your own poller might be a service which doesn't prioritize 
real-time data (maybe analytics or log processing) and intentionally allows a bit of 
backlog during heavy periods and catches up during quieter periods.



## Lambda Functions

The key feature of this mechanism is taking advantage of serverless infrastructure.

**Pros**

* Don't have to run a service to receive and process messages.
* Scaled up for you at the rate of the topic(s).
* No need to deal with ports, protocols, or other ops/machine concerns.

**Cons**

* You don't manage your application lifecycle, and you cannot run other tasks
  concurrent with your message invocations.
* Pay per-invocation plus per-CPU-mem usage, may end up costing more than 
  a service with the poller.


### When to use Lambda Functions

A lambda is well-suited when the amount of work done per message invocation is
small and straightforward. Examples include inserting results into a DB
or forwarding to another messaging system such as Kinesis.

Lambda can also be affordable for some CPU-heavy workloads such as image
processing and other tasks, but you will need to test your workload in the 
lambda to see how it fares against EC2, ECS, etc.
