package encryption

type Provider interface {
	Environment() string
	Encrypter() Encrypter
}

type Encrypter interface {
	EncryptString(map[string]string, string) ([]byte, error)
	EncryptFloat32(map[string]string, float32) ([]byte, error)
	EncryptFloat64(map[string]string, float64) ([]byte, error)
	EncryptInt32(map[string]string, int32) ([]byte, error)
	EncryptInt64(map[string]string, int64) ([]byte, error)
}

type Decrypter interface {
	DecryptString([]byte) (string, error)
	DecryptFloat32([]byte) (float32, error)
	DecryptFloat64([]byte) (float64, error)
	DecryptInt32([]byte) (int32, error)
	DecryptInt64([]byte) (int64, error)
}
