package eventbus_test

import (
	"context"
	"log"

	eventbus "code.justin.tv/eventbus/client"
)

func ExampleMux_RegisterNotFoundHandler(mux *eventbus.Mux) {
	mux.HandleDefault(func(ctx context.Context, m eventbus.RawMessage) error {
		log.Printf("Unrecognized eventbus message %s", m.Header.EventType)

		// Returning nil error marks this message as complete, so it will
		// never be seen again and not be dead-lettered.
		return nil
	})
}
