package testevents

import (
	"encoding/base64"

	"github.com/golang/protobuf/ptypes/timestamp"

	"code.justin.tv/eventbus/client/internal/testschema/clock"
)

const April1UTCSeconds = int64(1522540800)

func UUID1() []byte {
	return []byte{0xa, 0xd, 0xe0, 0xdd, 0x99, 0xe3, 0x4e, 0xba, 0x8e, 0xcd, 0x93, 0x77, 0xb6, 0xf2, 0xa6, 0xda}
}

const (
	// A clock tick that happened on April 1 2018, 00:00:00 UTC
	ClockUpdateApril1 = b64("AQAnChAKDeDdmeNOuo7Nk3e28qbaEgtDbG9ja1VwZGF0ZRoGCIDCgNYFCgYIgMKA1gU")

	// A message which is valid header framing, but invalid message ID
	InvalidMessageID = b64("AQATEglDbG9ja1RpY2saBgiAwoDWBQiAwoDWBQ")
)

// b64 is a helper to use base64 string constants for multiple purposes.
type b64 string

func (s b64) String() string {
	return string(s)
}

func (s b64) Bytes() []byte {
	buf, _ := base64.RawURLEncoding.DecodeString(string(s))
	return buf
}

func NewClockUpdate(seconds int64, nanos ...int32) *clock.ClockUpdate {
	ts := &timestamp.Timestamp{Seconds: seconds}
	if len(nanos) > 1 {
		panic("nanos only once")
	} else if len(nanos) != 0 {
		ts.Nanos = nanos[0]
	}
	return &clock.ClockUpdate{
		Time: ts,
	}
}
