package testevents

import (
	"encoding/base64"
	"testing"

	"github.com/golang/protobuf/ptypes/timestamp"
	"github.com/stretchr/testify/require"

	"code.justin.tv/eventbus/client/internal/testschema/clock"
	"code.justin.tv/eventbus/client/internal/wire"
)

func TestRegression(t *testing.T) {
	h := &wire.HeaderV1{
		MessageId: UUID1(),
		EventType: "ClockUpdate",
		CreatedAt: &timestamp.Timestamp{Seconds: April1UTCSeconds},
	}
	buf, err := wire.EncodeRaw(h, &clock.ClockUpdate{Time: &timestamp.Timestamp{Seconds: April1UTCSeconds}})
	require.NoError(t, err)
	encoded := base64.RawURLEncoding.EncodeToString(buf)
	require.Equal(t, ClockUpdateApril1.String(), encoded)
	require.Equal(t, ClockUpdateApril1.Bytes(), buf)

}
