package wire

import (
	"testing"
	"time"

	uuid "github.com/gofrs/uuid"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestNoop(t *testing.T) {
	when := time.Date(2019, 4, 1, 12, 20, 0, 0, time.UTC)

	t.Run("EncodeNoop", func(t *testing.T) {
		buf, err := EncodeNoop(uuid.Must(uuid.NewV4()), "development", when)
		require.NoError(t, err)
		assert.Len(t, buf, 44)

		t.Run("and decode it back", func(t *testing.T) {
			h, payload, err := HeaderAndPayload(buf)
			require.NoError(t, err)
			assert.Empty(t, h.EventType)
			assert.Equal(t, "development", h.Environment)
			assert.Equal(t, MessageType_NOOP, h.Type)
			assert.Equal(t, when.Unix(), h.CreatedAt.GetSeconds())
			assert.Empty(t, payload)
			assert.True(t, IsNoop(h))
		})
	})

	t.Run("IsNoop", func(t *testing.T) {
		assert.True(t, IsNoop(&HeaderV1{Type: MessageType_NOOP}))
		assert.False(t, IsNoop(&HeaderV1{Type: MessageType_DEFAULT}))
		assert.False(t, IsNoop(&HeaderV1{Type: MessageType_NOOP, EventType: "FooBar"}))
	})
}
