package foobar

import (
	"errors"

	"code.justin.tv/eventbus/client/encryption"
)

type Create = FoobarCreate

// This is not a real Protobuf message, it will not marshal properly.
// It is meant to be used only with mock clients!
type FoobarCreate struct {
	Garply string
	Baz    *FakeAuthorizedField
}

func (m *FoobarCreate) SetEncryptedBaz(p encryption.Provider, s string) error {
	if m == nil {
		return errors.New("nil pointer receiver in encrypt call")
	}

	enc := p.Encrypter()
	payload, err := enc.EncryptString(map[string]string{
		"EventType":   "FoobarCreate",
		"Environment": p.Environment(),
		"MessageName": "FoobarCreate",
		"FieldName":   "Baz",
	}, s)
	if err != nil {
		return err
	}

	m.Baz = &FakeAuthorizedField{
		Payload: payload,
	}
	return nil
}

func (m *FoobarCreate) GetDecryptedSecretTime(dec encryption.Decrypter) (string, error) {
	if m == nil {
		return "", errors.New("nil pointer receiver in decrypt call")
	}
	if m.GetBaz() == nil {
		return "", nil
	}
	return dec.DecryptString(m.GetBaz().Payload)
}

func (m *FoobarCreate) GetGarply() string {
	if m == nil {
		return ""
	}
	return m.Garply
}

func (m *FoobarCreate) GetBaz() *FakeAuthorizedField {
	if m == nil {
		return nil
	}
	return m.Baz
}

func (m *FoobarCreate) EventBusName() string {
	return "FoobarCreate"
}

func (m *FoobarCreate) Reset() {}

func (m *FoobarCreate) String() string {
	return ""
}

func (m *FoobarCreate) ProtoMessage() {}

type FakeAuthorizedField struct {
	Payload []byte
}
