package mock

import "sync"

type AuthorizedFieldClient struct {
	DecryptCalls []DecryptCall

	DecryptHandler func(*AuthorizedFieldClient, []byte) (string, error)

	mu sync.Mutex
}

func (c *AuthorizedFieldClient) DecryptString(b []byte) (string, error) {
	c.mu.Lock()
	c.DecryptCalls = append(c.DecryptCalls, DecryptCall{
		Payload: b,
	})
	c.mu.Unlock()

	var err error
	var s string
	if handler := c.DecryptHandler; handler != nil {
		s, err = handler(c, b)
	} else {
		s = string(b)
	}
	return s, err
}

type DecryptCall struct {
	Payload []byte
}
