package lambdafunc_test

import (
	"context"
	"log"

	"github.com/aws/aws-lambda-go/lambda"

	eventbus "code.justin.tv/eventbus/client"
	"code.justin.tv/eventbus/client/internal/testschema/clock"
	"code.justin.tv/eventbus/client/subscriber/lambdafunc"
)

// This example sets up a lambda function handler to receive ClockUpdate
// messages via SQS.
func Example() {
	mux := eventbus.NewMux()
	clock.RegisterClockUpdateHandler(mux, clockUpdate)

	lambda.Start(lambdafunc.NewSQS(mux.Dispatcher()))
}

func clockUpdate(ctx context.Context, h *eventbus.Header, event *clock.ClockUpdate) error {
	log.Printf("Got clock event: %d", event.Time.GetSeconds())
	return nil
}
