package testhelpers_test

import (
	"fmt"
	"time"

	"github.com/gofrs/uuid"

	eventbus "code.justin.tv/eventbus/client"
	"code.justin.tv/eventbus/client/internal/testschema/user_password"
	"code.justin.tv/eventbus/client/testhelpers"
)

func Example_encode_idempotent() {
	// use a fixed date & UUID so that the outputs are idempotent.
	header := &eventbus.Header{
		CreatedAt:   time.Date(2020, 1, 4, 14, 25, 0, 0, time.UTC),
		MessageID:   uuid.Must(uuid.FromString("ed280816-e404-444a-a2d9-ffd2d171f928")),
		Environment: "testing",
	}

	message := &user_password.Update{
		UserId: "1234",
	}

	raw, err := testhelpers.MakePayload(header, message)
	if err != nil {
		fmt.Println(err.Error())
	}

	fmt.Println("SNS Message: " + raw.SNSPayload())

	snsMessage := raw.FakeSNSMessage()
	// We are overriding the message ID and timestamp so that we get idempotent outputs
	snsMessage.MessageID = "8E7C2F0A-6BB8-485C-917E-6B605A0DDF29"
	snsMessage.Timestamp = header.CreatedAt.Add(1 * time.Second)

	sqsBody, err := snsMessage.SQSBody()
	if err != nil {
		fmt.Println(err.Error())
	}
	fmt.Println("SQS Body: " + sqsBody)
	// Output: SNS Message: AQA3ChDtKAgW5ARESqLZ_9LRcfkoEhJVc2VyUGFzc3dvcmRVcGRhdGUaBgi8wMLwBSoHdGVzdGluZwoEMTIzNA
	// SQS Body: {"MessageId":"8E7C2F0A-6BB8-485C-917E-6B605A0DDF29","Type":"Notification","TopicArn":"arn:aws:sns:us-west-2:123456789012:eventbus-fake","Timestamp":"2020-01-04T14:25:01Z","Message":"AQA3ChDtKAgW5ARESqLZ_9LRcfkoEhJVc2VyUGFzc3dvcmRVcGRhdGUaBgi8wMLwBSoHdGVzdGluZwoEMTIzNA"}
}
