package testhelpers_test

import (
	"fmt"
	"time"

	"github.com/gofrs/uuid"

	eventbus "code.justin.tv/eventbus/client"
	"code.justin.tv/eventbus/client/internal/testschema/user"
	"code.justin.tv/eventbus/client/testhelpers"
)

func Example_encode_sqs() {
	// Because we use time.Now() and a random UUID, the output will vary each time,
	// but be more like real eventbus messages.
	header := &eventbus.Header{
		CreatedAt:   time.Now().UTC(),
		MessageID:   uuid.Must(uuid.NewV4()),
		Environment: "testing",
	}

	message := &user.Destroy{
		UserId: "1234",
		Login:  "FooPerson",
	}

	raw, err := testhelpers.MakePayload(header, message)
	if err != nil {
		fmt.Println(err.Error())
	}

	snsMessage := raw.FakeSNSMessage()

	fmt.Printf("SNS message ID=%s, Payload=%s", snsMessage.MessageID, snsMessage.Message)
}
