package server

import (
	"context"
	"time"

	"github.com/golang/protobuf/ptypes"

	rpc "code.justin.tv/eventbus/clock/rpc"
)

func (s *Server) GetTimestamp(ctx context.Context, req *rpc.GetTimestampReq) (*rpc.GetTimestampResp, error) {
	protoTimestamp, err := ptypes.TimestampProto(time.Now())
	if err != nil {
		return nil, err
	}

	return &rpc.GetTimestampResp{
		Timestamp: protoTimestamp,
	}, nil
}
