locals {
  region   = "us-west-2"
  app_name = "clock"
}

provider "aws" {
  version = "~> 2.7"
  region  = "${local.region}"
}

terraform {
  required_version = ">= 0.11"

  backend "s3" {
    bucket = "twitch-clock-prod"
    key    = "tfstate/eventbus/twitch-clock-prod/account/terraform.tfstate"
    region = "us-west-2"
  }
}

resource "aws_ecr_repository" "main" {
  name = "${local.app_name}"
}

resource "aws_ecr_lifecycle_policy" "clock-lifecycle-policy" {
  repository = "${aws_ecr_repository.main.name}"

  policy = <<EOF
{
    "rules": [
        {
            "rulePriority": 1,
            "description": "Keep 30 most recent images",
            "selection": {
                "tagStatus": "any",
                "countType": "imageCountMoreThan",
                "countNumber": 30
            },
            "action": {
                "type": "expire"
            }
        }
    ]
}
EOF
}

module "vpc_resolver" {
  source      = "../../modules/vpc_resolver"
  environment = "prod"
}
