module "twitch_networking" {
  source = "../../modules/twitch_networking"
  environment = "staging"
}

module "ldap_vpc_endpoint" {
  source               = "../../modules/ldap_legacy_vpc_endpoint"
  vpc_endpoint_service = "com.amazonaws.vpce.us-west-2.vpce-svc-02673a2089b1caf6d"
}

module "ldap_a2z_vpc_endpoint" {
  source               = "../../modules/vpc_endpoint"
  vpc_endpoint_service = "com.amazonaws.vpce.us-west-2.vpce-svc-0437151f68c61b808"
  environment          = "staging"
  endpoint_alias       = "ldap.twitch.a2z.com"
  vpc_id               = module.twitch_networking.vpc_id
}
