provider "aws" {
  version = "~> 2.70"
  region  = "us-west-2"
}

locals {
  region        = "us-west-2"
  environment   = "prod"
  account_name  = "twitch-clock-prod"
  account_id    = "384110337398"
  task_memory   = 1024
  task_cpu      = 1024
  instance_type = "c5.large"
  app_count     = 1
  image_tag     = "fbfb442"           # used to prime environment, will be ignored on deploys
}

terraform {
  required_version = ">= 0.11"

  backend "s3" {
    bucket = "twitch-clock-prod"
    key    = "tfstate/eventbus/twitch-clock-prod/terraform.state"
    region = "us-west-2"
  }
}

data "terraform_remote_state" "account" {
  backend = "s3"

  config = {
    bucket = "twitch-clock-prod"
    key    = "tfstate/eventbus/twitch-clock-prod/account/terraform.tfstate"
    region = "us-west-2"
  }
}

module "app" {
  source = "../../modules/app"

  environment       = "${local.environment}"
  app_image         = "${local.account_id}.dkr.ecr.${local.region}.amazonaws.com/clock:${local.image_tag}"
  app_count         = "${local.app_count}"
  ec2_instance_type = "${local.instance_type}"
  task_memory       = "${local.task_memory}"
  task_cpu          = "${local.task_cpu}"
  cluster_size      = "${var.cluster_size}"

  # override the staging default dns servers
  # https://wiki.twitch.com/display/SYS/What+DNS+servers+should+be+used
  dns_servers = ["10.203.126.62", "10.203.124.218", "10.203.125.211", "10.203.126.205"]
}
