provider "aws" {
  version = "~> 2.7"
  region  = "us-west-2"
}

locals {
  region        = "us-west-2"
  environment   = "staging"
  account_name  = "twitch-clock-dev"
  account_id    = "065305400592"
  task_memory   = 1024
  task_cpu      = 1024
  instance_type = "c5.large"
  app_count     = 1
  image_tag     = "3595abc"          # used to prime env
}

terraform {
  required_version = ">= 0.11"

  backend "s3" {
    bucket = "twitch-clock-dev"
    key    = "tfstate/eventbus/twitch-clock-dev/terraform.state"
    region = "us-west-2"
  }
}

data "terraform_remote_state" "account" {
  backend = "s3"

  config = {
    bucket = "twitch-clock-dev"
    key    = "tfstate/eventbus/twitch-clock-dev/account/terraform.tfstate"
    region = "us-west-2"
  }
}

module "app" {
  source = "../../modules/app"

  environment       = "${local.environment}"
  app_image         = "${local.account_id}.dkr.ecr.${local.region}.amazonaws.com/clock:${local.image_tag}"
  app_count         = "${local.app_count}"
  ec2_instance_type = "${local.instance_type}"
  task_memory       = "${local.task_memory}"
  task_cpu          = "${local.task_cpu}"
  cluster_size      = "${var.cluster_size}"
}
