locals {
  ssh_sudoer_ldap_group = "team-api"
  team_name             = "edge-notifications"
  app_name              = "clock"
  owner_email           = "edge-notifications@twitch.tv"

  region       = "us-west-2"
  app_env_name = "${local.app_name}-${var.environment}"
  cluster_name = "${local.app_env_name}"
}

data "aws_iam_account_alias" "current" {}
data "aws_caller_identity" "current" {}

module "core_account" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/twitch/terraform//core_account?ref=v2.1.2"

  environment = "${var.environment}"
  team        = "${local.team_name}"
  xray_role   = "*"
}

module "ecs" {
  source = "../ecs"

  ecs_host_iam_id       = "${module.core_account.container_instance_profile_id}"
  cluster_name          = "${local.cluster_name}"
  owner_email           = "${local.owner_email}"
  environment           = "${var.environment}"
  app_name              = "${local.app_name}"
  ssh_sudoer_ldap_group = "${local.ssh_sudoer_ldap_group}"
  service_iam_role      = "${module.core_account.service_iam_role}"

  ec2_instance_type = "${var.ec2_instance_type}"
  cluster_size      = "${var.cluster_size}"

  app_image   = "${var.app_image}"
  app_count   = "${var.app_count}"
  task_memory = "${var.task_memory}"
  task_cpu    = "${var.task_cpu}"

  dns_servers = "${var.dns_servers}"

  target_group_id = "${var.target_group_id}"
}
